/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.TriggerRegistrar;
import xfacthd.framedblocks.api.util.CamoMessageVerbosity;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

public abstract class CamoContainerFactory<T extends CamoContainer<?, T>> {
    public static final Component MSG_BLACKLISTED = Utils.translate("msg", "camo.blacklisted");

    @ApiStatus.OverrideOnly
    protected abstract void writeToNetwork(CompoundTag var1, T var2);

    @ApiStatus.OverrideOnly
    protected abstract T readFromNetwork(CompoundTag var1);

    @Nullable
    public abstract T applyCamo(Level var1, BlockPos var2, Player var3, ItemStack var4);

    public abstract boolean removeCamo(Level var1, BlockPos var2, Player var3, ItemStack var4, T var5);

    public abstract boolean canTriviallyConvertToItemStack();

    public abstract ItemStack dropCamo(T var1);

    public abstract boolean validateCamo(T var1);

    protected static void displayValidationMessage(@Nullable Player player, Component message, CamoMessageVerbosity verbosity) {
        if (player == null || !player.level().isClientSide()) {
            return;
        }
        if (ConfigView.Client.INSTANCE.getCamoMessageVerbosity().isAtLeast(verbosity)) {
            player.displayClientMessage(message, true);
        }
    }

    public T handleInteraction(Level level, BlockPos pos, Player player, T camo, ItemStack stack, InteractionHand hand) {
        return this.handleInteraction(level, pos, player, camo, stack);
    }

    @Deprecated(forRemoval=true, since="10.2.1")
    public T handleInteraction(Level level, BlockPos pos, Player player, T camo, ItemStack stack) {
        return camo;
    }

    public boolean canApplyInCraftingRecipe(ItemStack stack) {
        return false;
    }

    public T applyCamoInCraftingRecipe(ItemStack stack) {
        throw new UnsupportedOperationException("Application via crafting is not supported");
    }

    public ItemStack getCraftingRemainder(ItemStack stack) {
        throw new UnsupportedOperationException("Application via crafting is not supported");
    }

    public abstract MapCodec<T> codec();

    public abstract StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec();

    public abstract void registerTriggerItems(TriggerRegistrar var1);
}

