/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.entity;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class EntityHelperClient {
    public static List<? extends Entity> clientGetTarget(@NotNull String input) {
        if (Minecraft.getInstance().player != null) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (input.startsWith("@")) {
                AABB aABB;
                EntitySelector selector;
                EntitySelectorParser parser = new EntitySelectorParser(new StringReader(input), true);
                try {
                    selector = parser.parse();
                }
                catch (CommandSyntaxException e) {
                    return Collections.emptyList();
                }
                Vec3 vec3d = (Vec3)selector.position.apply(new Vec3(player.getX(), player.getY(), player.getZ()));
                AABB aABB2 = aABB = selector.aabb != null ? selector.aabb.move(vec3d) : player.getBoundingBox().inflate(256.0, 256.0, 256.0);
                if (selector.currentEntity) {
                    Predicate predicate = selector.getPredicate(vec3d, aABB, (FeatureFlagSet)null);
                    return predicate.test(player) ? List.of(player) : List.of();
                }
                Predicate predicate = selector.getPredicate(vec3d, aABB, player.level().enabledFeatures());
                ObjectArrayList list = new ObjectArrayList();
                list.addAll(player.level().getEntities(selector.type, selector.aabb != null ? selector.aabb.move(vec3d) : player.getBoundingBox().inflate(256.0, 256.0, 256.0), predicate));
                return selector.sortAndLimit(vec3d, (List)list);
            }
            try {
                UUID uuid = UUID.fromString(input);
                for (Entity entity : Minecraft.getInstance().level.entitiesForRendering()) {
                    if (!uuid.equals(entity.getUUID())) continue;
                    return Lists.newArrayList((Object[])new Entity[]{entity});
                }
                for (Player worldPlayer : player.level().players()) {
                    if (!worldPlayer.getUUID().equals(uuid)) continue;
                    return Lists.newArrayList((Object[])new Player[]{worldPlayer});
                }
            }
            catch (IllegalArgumentException var4) {
                for (Player worldPlayer : player.level().players()) {
                    if (!worldPlayer.getName().getString().equals(input)) continue;
                    return Lists.newArrayList((Object[])new Player[]{worldPlayer});
                }
            }
        }
        return Collections.emptyList();
    }
}

