/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.mixin;

import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Bee.BeePollinateGoal.class})
public abstract class BeePollinateGoalMixin {
    @Final
    @Shadow
    private Bee this$0;
    private final Predicate<BlockPos> VALID_POLLINATION_BLOCKS = blockPos -> {
        BlockState blockState = this.this$0.level().getBlockState(blockPos);
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return false;
        }
        if (blockState.is(BlockTags.FLOWERS)) {
            return !blockState.is(Blocks.SUNFLOWER) || blockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER;
        }
        BlockEntity patt0$temp = this.this$0.level().getBlockEntity(blockPos);
        if (patt0$temp instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)patt0$temp;
            return ProductiveBee.isValidFeeder(this.this$0, (BlockEntity)feederBlockEntity, state -> state.is(BlockTags.FLOWERS), stack -> stack.is(ItemTags.FLOWERS));
        }
        return false;
    };

    private Optional<BlockPos> findNearestBlock(Predicate<BlockPos> predicate, double distance) {
        BlockPos blockpos = this.this$0.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = 0;
        while ((double)i <= distance) {
            int j = 0;
            while ((double)j < distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, k, i - 1, l);
                        if (blockpos.closerThan((Vec3i)blockpos$mutableblockpos, distance) && predicate.test((BlockPos)blockpos$mutableblockpos)) {
                            return Optional.of(blockpos$mutableblockpos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }

    @Inject(at={@At(value="RETURN")}, method={"findNearbyFlower"})
    public void findNearbyFlower(CallbackInfoReturnable<Optional<BlockPos>> ci) {
        if (((Optional)ci.getReturnValue()).isEmpty()) {
            this.findNearestBlock(this.VALID_POLLINATION_BLOCKS, 5.0);
        }
    }
}

