/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.IncubatorBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class IncubatorContainer
extends AbstractContainer<IncubatorBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_CATALYST = 1;
    public static final int SLOT_OUTPUT = 2;

    public IncubatorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, IncubatorContainer.getBlockEntity(playerInventory, data));
    }

    public IncubatorContainer(int windowId, Inventory playerInventory, final IncubatorBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.INCUBATOR.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (blockEntity.energyHandler.getEnergyStored() > 0) {
                    blockEntity.energyHandler.extractEnergy(blockEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    blockEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.recipeProgress;
            }

            public void set(int value) {
                blockEntity.recipeProgress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((IncubatorBlockEntity)this.getBlockEntity()).getItemHandler(), 0, 52, 35));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((IncubatorBlockEntity)this.getBlockEntity()).getItemHandler(), 1, 80, 53));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((IncubatorBlockEntity)this.getBlockEntity()).getItemHandler(), 2, 108, 35));
        this.addSlotBox((IItemHandler)((IncubatorBlockEntity)this.getBlockEntity()).getUpgradeHandler(), 0, 178, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static IncubatorBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof IncubatorBlockEntity) {
            return (IncubatorBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

