/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.entity.CryoStasisBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.ICapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CryoStasisContainer
extends AbstractContainer<CryoStasisBlockEntity> {
    public CryoStasisContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CryoStasisContainer.getTileEntity(playerInventory, data));
    }

    public CryoStasisContainer(int windowId, Inventory playerInventory, CryoStasisBlockEntity blockEntity) {
        super((MenuType)ModContainerTypes.CRYO_STASIS.get(), (ICapabilityBlockEntity)blockEntity, windowId);
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((CryoStasisBlockEntity)this.getBlockEntity()).getItemHandler(), CryoStasisBlockEntity.SLOT_INPUT, 108, 18));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((CryoStasisBlockEntity)this.getBlockEntity()).getItemHandler(), CryoStasisBlockEntity.SLOT_CAGE, 108, 36));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)((CryoStasisBlockEntity)this.getBlockEntity()).getItemHandler(), CryoStasisBlockEntity.SLOT_OUT, 108, 54));
        this.layoutPlayerInventorySlots(playerInventory, 0, 108, 84);
    }

    private static CryoStasisBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof CryoStasisBlockEntity) {
            return (CryoStasisBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }
}

