/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import cy.jdkdigital.productivebees.common.recipe.ItemConversionRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.init.ModBlocks;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemConversionRecipeCategory
implements IRecipeCategory<ItemConversionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public ItemConversionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/block_conversion.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 90, 52);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FEEDER.get()));
    }

    public RecipeType<ItemConversionRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.ITEM_CONVERSION_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.productivebees.item_conversion");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ItemConversionRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 38, 5).addIngredients(ProductiveBeesJeiPlugin.BEE_INGREDIENT, recipe.getBees())).setSlotName("source");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 25).addItemStacks(Arrays.asList(recipe.ingredient.getItems()))).setSlotName("sourceitem");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 65, 25).addItemStacks(List.of(recipe.output))).setSlotName("resultItem");
    }

    public void draw(ItemConversionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.drawString(minecraft.font, Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"jei.productivebees.block_conversion.chance", (Object[])new Object[]{Float.valueOf(recipe.chance * 100.0f)})), 0, 45, -16777216, false);
    }
}

