/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.crafting.conditions;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public record BeeExistsCondition(ResourceLocation beeName) implements ICondition
{
    public static MapCodec<BeeExistsCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("bee").forGetter(BeeExistsCondition::beeName)).apply((Applicative)builder, BeeExistsCondition::new));

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public boolean test(ICondition.IContext context) {
        JsonObject beeData = BeeReloadListener.INSTANCE.getCondition(this.beeName.toString());
        if (beeData != null) {
            DataResult conditions;
            boolean enabled;
            boolean bl = enabled = !beeData.has("conditions");
            if (!enabled && (conditions = ICondition.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)beeData.getAsJsonArray("conditions"))).isSuccess()) {
                enabled = true;
                for (ICondition condition : (List)((Pair)conditions.result().get()).getFirst()) {
                    if (condition.test(context)) continue;
                    enabled = false;
                }
            }
            return enabled;
        }
        return false;
    }

    @Override
    public String toString() {
        return "bee_exists(\"" + String.valueOf(this.beeName) + "\")";
    }
}

