/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.HoneyGenerator;
import cy.jdkdigital.productivebees.container.HoneyGeneratorContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivelib.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.IUpgradeableBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class HoneyGeneratorBlockEntity
extends FluidTankBlockEntity
implements MenuProvider,
IUpgradeableBlockEntity {
    protected int tickCounter = 0;
    public int fluidId = 0;
    public boolean hasLoaded = false;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 2, (BlockEntity)this){

        public boolean isContainerItem(Item item) {
            return item.equals(Items.HONEY_BOTTLE) || item.builtInRegistryHolder().is(ModTags.Common.HONEY_BUCKETS) || item.equals(Items.HONEY_BLOCK);
        }

        public boolean isInputSlot(int slot) {
            return slot == 0;
        }
    };
    public FluidTank fluidHandler = new FluidTank(10000, fluidStack -> fluidStack.getFluid().is(ModTags.HONEY)){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (this.fluid.getAmount() > 0) {
                HoneyGeneratorBlockEntity.this.setFilled(true);
            } else {
                HoneyGeneratorBlockEntity.this.setFilled(false);
            }
            HoneyGeneratorBlockEntity.this.fluidId = BuiltInRegistries.FLUID.getId((Object)this.getFluid().getFluid());
            HoneyGeneratorBlockEntity.this.setChanged();
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY.get()));
    public EnergyStorage energyHandler = new EnergyStorage(100000);
    private List<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();

    private void setFilled(boolean filled) {
        if (this.level != null && !this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)HoneyGenerator.FULL, (Comparable)Boolean.valueOf(filled)));
        }
    }

    private void setOn(boolean filled) {
        if (this.level != null && !this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)HoneyGenerator.ON, (Comparable)Boolean.valueOf(filled)));
        }
    }

    public HoneyGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HoneyGeneratorBlockEntity blockEntity) {
        int tickRate = 10;
        if (!blockEntity.hasLoaded) {
            blockEntity.refreshConnectedTileEntityCache();
            blockEntity.hasLoaded = true;
        }
        if (++blockEntity.tickCounter % tickRate == 0) {
            double consumeModifier = 1.0 + (double)blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY.get());
            double speedModifier = 1.0 + (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
            int inputPowerAmount = (int)((double)((Integer)ProductiveBeesConfig.GENERAL.generatorPowerGen.get() * tickRate) * speedModifier);
            int fluidConsumeAmount = (int)((double)((Integer)ProductiveBeesConfig.GENERAL.generatorHoneyUse.get() * tickRate) * speedModifier / consumeModifier);
            if (blockEntity.fluidHandler.getFluidInTank(0).getAmount() >= fluidConsumeAmount && blockEntity.energyHandler.receiveEnergy(inputPowerAmount, true) > 0) {
                blockEntity.energyHandler.receiveEnergy(inputPowerAmount, false);
                blockEntity.fluidHandler.drain(fluidConsumeAmount, IFluidHandler.FluidAction.EXECUTE);
                blockEntity.setOn(true);
            } else {
                blockEntity.setOn(false);
            }
            blockEntity.sendOutPower(tickRate);
        }
        FluidTankBlockEntity.tick((Level)level, (BlockPos)pos, (BlockState)state, (FluidTankBlockEntity)blockEntity);
    }

    public void sendOutPower(int modifier) {
        AtomicInteger capacity;
        if (this.level != null && (capacity = new AtomicInteger(this.energyHandler.getEnergyStored())).get() > 0) {
            AtomicBoolean dirty = new AtomicBoolean(false);
            for (IEnergyStorage handler : this.recipients) {
                boolean doContinue = true;
                if (handler.canReceive()) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), 100 * modifier), false);
                    capacity.addAndGet(-received);
                    this.energyHandler.extractEnergy(received, false);
                    dirty.set(true);
                    boolean bl = doContinue = capacity.get() > 0;
                }
                if (doContinue) continue;
                break;
            }
            if (dirty.get()) {
                this.setChanged();
            }
        }
    }

    public void tickFluidTank(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        int fluidSpace = this.fluidHandler.getTankCapacity(0) - this.fluidHandler.getFluidInTank(0).getAmount();
        if (!this.inventoryHandler.getStackInSlot(0).isEmpty()) {
            ItemStack invItem = this.inventoryHandler.getStackInSlot(0);
            ItemStack outputInvItem = this.inventoryHandler.getStackInSlot(1);
            ItemStack outputItem = ItemStack.EMPTY;
            IFluidHandler itemFluidHandler = (IFluidHandler)invItem.getCapability(Capabilities.FluidHandler.ITEM);
            boolean isHoneyBottle = invItem.getItem().equals(Items.HONEY_BOTTLE);
            boolean isHoneyBlock = invItem.getItem().equals(Items.HONEY_BLOCK);
            boolean isHoneyBucket = invItem.is(ModTags.Common.HONEY_BUCKETS);
            int addAmount = 0;
            if (isHoneyBottle) {
                addAmount = 250;
                outputItem = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            } else if (isHoneyBlock) {
                addAmount = 1000;
            } else if (isHoneyBucket) {
                addAmount = 1000;
                outputItem = new ItemStack((ItemLike)Items.BUCKET);
            } else if (itemFluidHandler != null) {
                addAmount = fluidSpace;
            }
            if (!(outputItem.equals(ItemStack.EMPTY) || outputInvItem.isEmpty() || outputInvItem.getItem().equals(outputItem.getItem()) && outputInvItem.getMaxStackSize() != outputInvItem.getCount())) {
                return;
            }
            if (itemFluidHandler != null && itemFluidHandler.getFluidInTank(0).isEmpty()) {
                if (outputInvItem.isEmpty() && !this.inventoryHandler.insertItem(1, invItem, false).isEmpty()) {
                    this.inventoryHandler.setStackInSlot(0, ItemStack.EMPTY);
                }
                return;
            }
            if (addAmount > 0 && addAmount <= fluidSpace) {
                int fillAmount = this.fluidHandler.fill(new FluidStack((Fluid)ModFluids.HONEY.get(), addAmount), IFluidHandler.FluidAction.EXECUTE);
                if (itemFluidHandler != null && !isHoneyBucket && !isHoneyBottle) {
                    FluidUtil.tryEmptyContainer((ItemStack)invItem, (IFluidHandler)this.fluidHandler, (int)fillAmount, null, (boolean)true);
                } else {
                    invItem.shrink(1);
                    if (!outputItem.equals(ItemStack.EMPTY)) {
                        if (outputInvItem.isEmpty()) {
                            this.inventoryHandler.setStackInSlot(1, outputItem);
                        } else {
                            outputInvItem.grow(1);
                        }
                    }
                }
            }
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        Fluid fluid = this.fluidHandler.getFluidInTank(0).getFluid();
        this.fluidId = BuiltInRegistries.FLUID.getId((Object)fluid);
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.HONEY_GENERATOR.get()).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new HoneyGeneratorContainer(pContainerId, pPlayerInventory, this);
    }

    public void refreshConnectedTileEntityCache() {
        if (this.level instanceof ServerLevel) {
            Direction[] directions;
            ArrayList<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
            for (Direction direction : directions = Direction.values()) {
                IEnergyStorage energyCap;
                BlockEntity te = this.level.getBlockEntity(this.worldPosition.relative(direction));
                if (te == null || (energyCap = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(direction), (Object)direction.getOpposite())) == null) continue;
                recipients.add(energyCap);
            }
            this.recipients = recipients;
        }
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public EnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }
}

