/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.CanvasBeehiveBlockEntity;
import cy.jdkdigital.productivebees.compat.dyenamics.DyenamicsCompat;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class CanvasBeehive
extends AdvancedBeehive {
    public CanvasBeehive(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CanvasBeehiveBlockEntity(pos, state);
    }

    @Override
    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : CanvasBeehive.createTickerHelper(blockEntityType, ModBlockEntityTypes.CANVAS_ADVANCED_HIVE.get(), AdvancedBeehiveBlockEntity::tick);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CanvasBeehiveBlockEntity) {
            CanvasBeehiveBlockEntity canvasBeehiveBlockEntity = (CanvasBeehiveBlockEntity)blockEntity;
            int color = 0;
            if (ModList.get().isLoaded("dyenamics") && DyenamicsCompat.isDye(stack)) {
                color = DyenamicsCompat.getColor(stack);
            } else {
                Item item = stack.getItem();
                if (item instanceof DyeItem) {
                    DyeItem dye = (DyeItem)item;
                    color = dye.getDyeColor().getTextureDiffuseColor();
                }
            }
            if (color != 0) {
                canvasBeehiveBlockEntity.setColor(color);
                if (!pLevel.isClientSide() && !pPlayer.isCreative()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        Object style = pStack.getItem().getDescriptionId().replace("block.productivebees.advanced_", "").replace("_canvas_beehive", "");
        style = ((String)style).substring(0, 1).toUpperCase() + ((String)style).substring(1);
        pTootipComponents.add((Component)Component.translatable((String)"productivebees.information.canvas.style", (Object[])new Object[]{Component.literal((String)style).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.WHITE));
    }
}

