/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.capabilities.attributes;

import cy.jdkdigital.productivebees.capabilities.attributes.IBeeAttributes;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class BeeAttributesHandler
implements IBeeAttributes,
INBTSerializable<CompoundTag> {
    protected Map<GeneAttribute, GeneValue> beeAttributes = new HashMap<GeneAttribute, GeneValue>();

    public BeeAttributesHandler() {
        Random rand = new Random();
        this.setAttributeValue(GeneAttribute.PRODUCTIVITY, GeneValue.getRandomProductivity(rand));
        this.setAttributeValue(GeneAttribute.TEMPER, GeneValue.TEMPER_NORMAL);
        this.setAttributeValue(GeneAttribute.ENDURANCE, GeneValue.getRandomEndurance(rand));
        this.setAttributeValue(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_DIURNAL);
        this.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_NONE);
    }

    @Override
    public GeneValue getAttributeValue(GeneAttribute attribute) {
        return this.beeAttributes.get((Object)attribute);
    }

    @Override
    public void setAttributeValue(GeneAttribute attribute, GeneValue value) {
        this.beeAttributes.put(attribute, value);
    }

    @Override
    public Map<GeneAttribute, GeneValue> getAttributes() {
        return this.beeAttributes;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putString("bee_productivity", this.getAttributeValue(GeneAttribute.PRODUCTIVITY).getSerializedName());
        tag.putString("bee_endurance", this.getAttributeValue(GeneAttribute.ENDURANCE).getSerializedName());
        tag.putString("bee_temper", this.getAttributeValue(GeneAttribute.TEMPER).getSerializedName());
        tag.putString("bee_behavior", this.getAttributeValue(GeneAttribute.BEHAVIOR).getSerializedName());
        tag.putString("bee_weather_tolerance", this.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).getSerializedName());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.setAttributeValue(GeneAttribute.PRODUCTIVITY, GeneValue.byName(tag.getString("bee_productivity")));
        this.setAttributeValue(GeneAttribute.ENDURANCE, GeneValue.byName(tag.getString("bee_endurance")));
        this.setAttributeValue(GeneAttribute.TEMPER, GeneValue.byName(tag.getString("bee_temper")));
        this.setAttributeValue(GeneAttribute.BEHAVIOR, GeneValue.byName(tag.getString("bee_behavior")));
        this.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.byName(tag.getString("bee_weather_tolerance")));
    }
}

