/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.ItemCraftedEvent;
import net.blay09.mods.balm.api.event.client.ConnectedToServerEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.CraftingGuideButtonFixer;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.GridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.DefaultGridGuiHandler;
import net.blay09.mods.craftingtweaks.api.impl.InternalClientMethodsImpl;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClientProviderManager;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksDebugger;
import net.blay09.mods.craftingtweaks.client.ModKeyMappings;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;
import net.blay09.mods.craftingtweaks.network.CraftStackMessage;
import net.blay09.mods.craftingtweaks.network.TransferStackMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class CraftingTweaksClient {
    private static final ClientProvider clientProvider = new ClientProvider();
    private static boolean ignoreMouseUp;
    private static int rightClickCraftingSlot;
    private static AbstractWidget unpleasantButton;
    private static int fixedUnpleasantButtonX;

    public static void initialize() {
        CraftingTweaksClientAPI.setupAPI(new InternalClientMethodsImpl());
        CraftingTweaksClientAPI.registerCraftingGridGuiHandler(AbstractContainerScreen.class, new DefaultGridGuiHandler());
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ItemCraftedEvent.class, CraftingTweaksClient::onItemCrafted);
        Balm.getEvents().onEvent(ConnectedToServerEvent.class, it -> {
            CraftingTweaks.isServerSideInstalled = false;
        });
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, CraftingTweaksClient::screenInitialized);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, CraftingTweaksClient::screenKeyPressed);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, CraftingTweaksClient::screenMouseClick);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, CraftingTweaksClient::screenMouseRelease);
        Balm.getEvents().onEvent(ScreenDrawEvent.Pre.class, CraftingTweaksClient::screenAboutToDraw);
        Balm.getEvents().onEvent(ScreenDrawEvent.Post.class, CraftingTweaksClient::screenDrawn);
        CraftingTweaksDebugger.initialize();
    }

    public static void screenKeyPressed(ScreenKeyEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Window window = Minecraft.getInstance().getWindow();
            if (CraftingTweaks.isServerSideInstalled && GLFW.glfwGetKey((long)window.getWindow(), (int)66) == 1 && GLFW.glfwGetKey((long)window.getWindow(), (int)76) == 1 && GLFW.glfwGetKey((long)window.getWindow(), (int)65) == 1 && (GLFW.glfwGetKey((long)window.getWindow(), (int)89) == 1 || GLFW.glfwGetKey((long)window.getWindow(), (int)90) == 1)) {
                CraftingTweaks.isServerSideInstalled = false;
                player.displayClientMessage((Component)Component.literal((String)"[CraftingTweaks] Enabled client-side testing mode"), false);
            }
        }
    }

    public static boolean screenMouseRelease(ScreenMouseEvent event) {
        if (ignoreMouseUp) {
            ignoreMouseUp = false;
            return true;
        }
        return false;
    }

    public static boolean screenMouseClick(ScreenMouseEvent event) {
        Screen screen = event.getScreen();
        int button = event.getButton();
        rightClickCraftingSlot = -1;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null) {
            return false;
        }
        Slot mouseSlot = screen instanceof AbstractContainerScreen ? ((AbstractContainerScreenAccessor)screen).getHoveredSlot() : null;
        CraftingGrid grid = CraftingTweaksProviderManager.getDefaultCraftingGrid(menu).orElse(null);
        if (grid != null) {
            if (ModKeyMappings.keyTransferStack.isActiveAndDown()) {
                if (mouseSlot != null && mouseSlot.hasItem()) {
                    ArrayList transferSlots = Lists.newArrayList();
                    transferSlots.add(mouseSlot);
                    if (Screen.hasShiftDown()) {
                        ItemStack mouseSlotStack = mouseSlot.getItem();
                        for (Slot slot : menu.slots) {
                            ItemStack slotStack;
                            if (!slot.hasItem() || mouseSlot == slot || !ItemStack.isSameItemSameComponents((ItemStack)(slotStack = slot.getItem()), (ItemStack)mouseSlotStack)) continue;
                            transferSlots.add(slot);
                        }
                    }
                    if (CraftingTweaks.isServerSideInstalled) {
                        for (Slot slot : transferSlots) {
                            Balm.getNetworking().sendToServer((CustomPacketPayload)new TransferStackMessage(grid.getId(), slot.index));
                        }
                    } else {
                        for (Slot slot : transferSlots) {
                            clientProvider.transferIntoGrid((Player)player, menu, grid, slot);
                        }
                        ignoreMouseUp = true;
                    }
                    return true;
                }
            } else if (CraftingTweaksConfig.getActive().client.rightClickCraftsStack && button == 1 && mouseSlot instanceof ResultSlot) {
                if (CraftingTweaks.isServerSideInstalled) {
                    Balm.getNetworking().sendToServer((CustomPacketPayload)new CraftStackMessage(mouseSlot.index));
                } else {
                    rightClickCraftingSlot = mouseSlot.index;
                }
                ignoreMouseUp = true;
                return true;
            }
        }
        return false;
    }

    public static void screenInitialized(ScreenInitEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            GridGuiHandler guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen);
            unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen, guiHandler);
            if (unpleasantButton != null) {
                fixedUnpleasantButtonX = unpleasantButton.getX();
            }
            List<CraftingGrid> grids = CraftingTweaksProviderManager.getCraftingGrids(containerScreen.getMenu());
            for (CraftingGrid grid : grids) {
                String modId = grid.getId().getNamespace();
                CraftingTweaksMode config = CraftingTweaksConfig.getActive().getCraftingTweaksMode(modId);
                if (config != CraftingTweaksMode.DEFAULT && config != CraftingTweaksMode.BUTTONS) continue;
                guiHandler.createButtons(containerScreen, grid, widget -> BalmClient.getScreens().addRenderableWidget(screen, widget));
            }
        }
    }

    private static void handleRightClickCrafting() {
        if (rightClickCraftingSlot == -1) {
            return;
        }
        int craftingSlot = rightClickCraftingSlot;
        rightClickCraftingSlot = -1;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        MultiPlayerGameMode playerController = Minecraft.getInstance().gameMode;
        if (playerController == null) {
            return;
        }
        AbstractContainerMenu menu = player.containerMenu;
        if (menu == null) {
            return;
        }
        if (craftingSlot >= menu.slots.size()) {
            return;
        }
        Slot mouseSlot = (Slot)menu.slots.get(craftingSlot);
        if (!mouseSlot.hasItem()) {
            rightClickCraftingSlot = mouseSlot.index;
            return;
        }
        ItemStack mouseStack = menu.getCarried();
        if (mouseStack.isEmpty() || mouseStack.getCount() + mouseSlot.getItem().getCount() <= mouseStack.getMaxStackSize()) {
            playerController.handleInventoryMouseClick(menu.containerId, mouseSlot.index, 0, ClickType.PICKUP, (Player)player);
            rightClickCraftingSlot = mouseSlot.index;
        }
    }

    public static void screenAboutToDraw(ScreenDrawEvent event) {
        Screen screen = event.getScreen();
        if (screen == null) {
            return;
        }
        if (screen instanceof AbstractContainerScreen) {
            GridGuiHandler guiHandler;
            int unpleasantX;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            if (unpleasantButton != null && (unpleasantX = unpleasantButton.getX()) != fixedUnpleasantButtonX && (unpleasantButton = CraftingGuideButtonFixer.fixMistakes(containerScreen, guiHandler = CraftingTweaksClientProviderManager.getGridGuiHandler(containerScreen))) != null) {
                fixedUnpleasantButtonX = unpleasantButton.getX();
            }
        }
    }

    public static void screenDrawn(ScreenDrawEvent event) {
        Screen screen = event.getScreen();
        if (screen == null) {
            return;
        }
        CraftingTweaksClient.handleRightClickCrafting();
    }

    private static void onItemCrafted(ItemCraftedEvent event) {
        clientProvider.onItemCrafted(event.getCraftMatrix());
    }

    public static ClientProvider getClientProvider() {
        return clientProvider;
    }

    static {
        rightClickCraftingSlot = -1;
    }
}

