/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.introspector;

import com.hypherionmc.simplerpc.jodd.introspector.ClassDescriptor;
import com.hypherionmc.simplerpc.jodd.introspector.MethodDescriptor;
import com.hypherionmc.simplerpc.jodd.util.ArraysUtil;
import com.hypherionmc.simplerpc.jodd.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Methods {
    protected final ClassDescriptor classDescriptor;
    protected final HashMap<String, MethodDescriptor[]> methodsMap;
    private MethodDescriptor[] allMethods;

    public Methods(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.methodsMap = this.inspectMethods();
    }

    protected HashMap<String, MethodDescriptor[]> inspectMethods() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        if (this.classDescriptor.isSystemClass()) {
            scanAccessible = false;
        }
        Class type = this.classDescriptor.getType();
        Method[] methods = scanAccessible ? ClassUtil.getAccessibleMethods(type) : ClassUtil.getSupportedMethods(type);
        HashMap<String, MethodDescriptor[]> map = new HashMap<String, MethodDescriptor[]>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            MethodDescriptor[] mds = map.get(methodName);
            mds = mds == null ? new MethodDescriptor[1] : ArraysUtil.resize(mds, mds.length + 1);
            map.put(methodName, mds);
            mds[mds.length - 1] = this.createMethodDescriptor(method);
        }
        return map;
    }

    protected MethodDescriptor createMethodDescriptor(Method method) {
        return new MethodDescriptor(this.classDescriptor, method);
    }

    public MethodDescriptor getMethodDescriptor(String name, Class[] paramTypes) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            Method m = methodDescriptor.getMethod();
            if (!ClassUtil.compareParameters(m.getParameterTypes(), paramTypes)) continue;
            return methodDescriptor;
        }
        return null;
    }

    public MethodDescriptor getMethodDescriptor(String name) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        if (methodDescriptors.length != 1) {
            throw new IllegalArgumentException("Method name not unique: " + name);
        }
        return methodDescriptors[0];
    }

    public MethodDescriptor[] getAllMethodDescriptors(String name) {
        return this.methodsMap.get(name);
    }

    public MethodDescriptor[] getAllMethodDescriptors() {
        if (this.allMethods == null) {
            ArrayList allMethodsList = new ArrayList();
            for (MethodDescriptor[] methodDescriptors : this.methodsMap.values()) {
                Collections.addAll(allMethodsList, methodDescriptors);
            }
            MethodDescriptor[] allMethods = allMethodsList.toArray(new MethodDescriptor[0]);
            Arrays.sort(allMethods, Comparator.comparing(md -> md.getMethod().getName()));
            this.allMethods = allMethods;
        }
        return this.allMethods;
    }
}

