/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PacketCodecs {
    public static <T extends Enum<T>> StreamCodec<ByteBuf, T> enumCodec(Class<T> enumClass) {
        return ByteBufCodecs.VAR_INT.map(ordinal -> ((Enum[])enumClass.getEnumConstants())[ordinal], Enum::ordinal);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Optional<T>> optional(StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, value -> value.isPresent(), (StreamCodec)ByteBufCodecs.optional(codec), Function.identity(), (present, value) -> value);
    }

    public static StreamCodec<ByteBuf, ResourceLocation> resourceLocation() {
        return ResourceLocation.STREAM_CODEC;
    }

    public static StreamCodec<ByteBuf, String> string() {
        return ByteBufCodecs.STRING_UTF8;
    }

    public static StreamCodec<ByteBuf, Integer> integer() {
        return ByteBufCodecs.VAR_INT;
    }

    public static StreamCodec<ByteBuf, Long> longValue() {
        return ByteBufCodecs.VAR_LONG;
    }

    public static StreamCodec<ByteBuf, Float> floatValue() {
        return ByteBufCodecs.FLOAT;
    }

    public static StreamCodec<ByteBuf, Double> doubleValue() {
        return ByteBufCodecs.DOUBLE;
    }

    public static StreamCodec<ByteBuf, Boolean> bool() {
        return ByteBufCodecs.BOOL;
    }

    public static StreamCodec<ByteBuf, Byte> byteValue() {
        return ByteBufCodecs.BYTE;
    }

    public static StreamCodec<ByteBuf, Short> shortValue() {
        return ByteBufCodecs.SHORT;
    }

    public static StreamCodec<ByteBuf, byte[]> byteArray() {
        return ByteBufCodecs.BYTE_ARRAY;
    }

    public static StreamCodec<ByteBuf, UUID> uuid() {
        return UUIDUtil.STREAM_CODEC;
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> itemStack() {
        return ItemStack.STREAM_CODEC;
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Item> item() {
        return ByteBufCodecs.registry((ResourceKey)Registries.ITEM);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Block> block() {
        return ByteBufCodecs.registry((ResourceKey)Registries.BLOCK);
    }

    public static StreamCodec<ByteBuf, BlockState> blockState() {
        return ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
    }

    public static StreamCodec<ByteBuf, BlockPos> blockPos() {
        return BlockPos.STREAM_CODEC;
    }

    public static StreamCodec<ByteBuf, GlobalPos> globalPos() {
        return GlobalPos.STREAM_CODEC;
    }

    public static StreamCodec<ByteBuf, Vec3> vec3() {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Vec3::x, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::y, (StreamCodec)ByteBufCodecs.DOUBLE, Vec3::z, Vec3::new);
    }

    public static StreamCodec<ByteBuf, Vector3f> vector3f() {
        return ByteBufCodecs.VECTOR3F;
    }

    public static StreamCodec<RegistryFriendlyByteBuf, MobEffectInstance> mobEffectInstance() {
        return MobEffectInstance.STREAM_CODEC;
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, List<T>> list(StreamCodec<RegistryFriendlyByteBuf, T> elementCodec) {
        return elementCodec.apply(ByteBufCodecs.list());
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, List<T>> list(StreamCodec<RegistryFriendlyByteBuf, T> elementCodec, int maxSize) {
        return elementCodec.apply(ByteBufCodecs.list((int)maxSize));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> itemStackWithCount() {
        return StreamCodec.composite(PacketCodecs.itemStack(), Function.identity(), PacketCodecs.integer(), ItemStack::getCount, (stack, count) -> {
            ItemStack copy = stack.copy();
            copy.setCount(count.intValue());
            return copy;
        });
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> itemStackNoNBT() {
        return StreamCodec.composite(PacketCodecs.item(), ItemStack::getItem, PacketCodecs.integer(), ItemStack::getCount, ItemStack::new);
    }

    public static StreamCodec<ByteBuf, EntityPosition> entityPosition() {
        return StreamCodec.composite(PacketCodecs.vec3(), EntityPosition::pos, PacketCodecs.floatValue(), EntityPosition::yaw, PacketCodecs.floatValue(), EntityPosition::pitch, EntityPosition::new);
    }

    public static StreamCodec<ByteBuf, PlayerData> playerData() {
        return StreamCodec.composite(PacketCodecs.uuid(), PlayerData::uuid, PacketCodecs.string(), PlayerData::name, PlayerData::new);
    }

    public static StreamCodec<ByteBuf, ResourceKey<Level>> dimension() {
        return ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION);
    }

    public record PlayerData(UUID uuid, String name) {
    }

    public record EntityPosition(Vec3 pos, float yaw, float pitch) {
    }
}

