/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.mojang.brigadier.CommandDispatcher;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.commands.CommandAura;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class CommonEvents {
    private static final Method GET_LOADED_CHUNKS_METHOD = ObfuscationReflectionHelper.findMethod(ChunkMap.class, (String)"getChunks", (Class[])new Class[0]);
    private static final SetMultimap<UUID, ChunkPos> PENDING_AURA_CHUNKS = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        LevelChunk chunk;
        IAuraChunk auraChunk;
        ChunkAccess iChunk = event.getChunk();
        if (iChunk instanceof LevelChunk && (auraChunk = (IAuraChunk)(chunk = (LevelChunk)iChunk).getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT)) instanceof AuraChunk) {
            LevelData data = (LevelData)ILevelData.getLevelData(chunk.getLevel());
            data.auraChunksWithSpots.remove(chunk.getPos().toLong());
        }
        SetMultimap<UUID, ChunkPos> setMultimap = PENDING_AURA_CHUNKS;
        synchronized (setMultimap) {
            PENDING_AURA_CHUNKS.values().remove(iChunk.getPos());
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.isEmpty() && BuiltInRegistries.ITEM.getKey((Object)held.getItem()).getPath().contains("chisel") && NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.containsKey((Object)(state = player.level().getBlockState(event.getPos())))) {
            LevelData data = (LevelData)ILevelData.getLevelData(player.level());
            data.addMossStone(event.getPos());
        }
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide && event.getLevel().getGameTime() % 20L == 0L) {
            event.getLevel().getProfiler().push("naturesaura:onLevelTick");
            try {
                ChunkMap manager = ((ServerChunkCache)event.getLevel().getChunkSource()).chunkMap;
                Iterable chunks = (Iterable)GET_LOADED_CHUNKS_METHOD.invoke((Object)manager, new Object[0]);
                for (ChunkHolder holder : chunks) {
                    AuraChunk auraChunk;
                    LevelChunk chunk = holder.getTickingChunk();
                    if (chunk == null || (auraChunk = (AuraChunk)chunk.getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT)) == null) continue;
                    auraChunk.update();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                NaturesAura.LOGGER.fatal((Object)e);
            }
            event.getLevel().getProfiler().pop();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide) {
            if (event.getEntity().level().getGameTime() % 10L == 0L) {
                Set pending = PENDING_AURA_CHUNKS.get((Object)event.getEntity().getUUID());
                pending.removeIf(p -> this.handleChunkWatchDeferred(event.getEntity(), (ChunkPos)p));
            }
            if (event.getEntity().level().getGameTime() % 200L != 0L) {
                return;
            }
            int aura = IAuraChunk.triangulateAuraInArea(event.getEntity().level(), event.getEntity().blockPosition(), 25);
            if (aura <= 0) {
                Helper.addAdvancement(event.getEntity(), ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"negative_imbalance"), "triggered_in_code");
            } else if (aura >= 1500000) {
                Helper.addAdvancement(event.getEntity(), ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"positive_imbalance"), "triggered_in_code");
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        PENDING_AURA_CHUNKS.removeAll((Object)event.getEntity().getUUID());
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        PENDING_AURA_CHUNKS.put((Object)event.getPlayer().getUUID(), (Object)event.getPos());
    }

    private boolean handleChunkWatchDeferred(Player player, ChunkPos pos) {
        ChunkAccess chunk = Helper.getLoadedChunk((LevelAccessor)player.level(), pos.x, pos.z);
        if (!(chunk instanceof LevelChunk)) {
            return false;
        }
        LevelChunk levelChunk = (LevelChunk)chunk;
        AuraChunk auraChunk = (AuraChunk)levelChunk.getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT);
        if (auraChunk == null) {
            return false;
        }
        PacketHandler.sendTo(player, auraChunk.makePacket());
        return true;
    }

    @SubscribeEvent
    public void onCommands(RegisterCommandsEvent event) {
        CommandAura.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

