/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;

public class NetherDecayEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"nether_decay");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 50);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura >= 0) {
            return false;
        }
        this.amount = Math.min(300, Mth.ceil((float)((float)Math.abs(aura) / 50000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = Mth.clamp((int)(Math.abs(aura) / 50000), (int)5, (int)75);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.level(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Items.SOUL_SAND);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, IAuraChunk.DrainSpot actualSpot) {
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + level.random.nextInt(this.amount / 2); i >= 0; --i) {
            BlockPos offset = BlockPos.containing((double)((double)pos.getX() + level.random.nextGaussian() * (double)this.dist), (double)((double)pos.getY() + level.random.nextGaussian() * (double)this.dist), (double)((double)pos.getZ() + level.random.nextGaussian() * (double)this.dist));
            if (offset.distSqr((Vec3i)pos) > (double)(this.dist * this.dist) || !level.isLoaded(offset)) continue;
            Block degraded = null;
            BlockState state = level.getBlockState(offset);
            if (state.getBlock() == Blocks.GLOWSTONE) {
                degraded = Blocks.NETHERRACK;
            } else if (state.is(BlockTags.NYLIUM) || state.getBlock() == Blocks.NETHERRACK) {
                degraded = Blocks.SOUL_SOIL;
            } else if (state.getBlock() == Blocks.SOUL_SOIL) {
                degraded = Blocks.SOUL_SAND;
            }
            if (degraded != null) {
                level.levelEvent(2001, offset, Block.getId((BlockState)state));
                level.setBlockAndUpdate(offset, degraded.defaultBlockState());
            }
            if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)offset, (Direction)Direction.NORTH)) continue;
            BlockState fire = BaseFireBlock.getState((BlockGetter)level, (BlockPos)offset);
            level.setBlockAndUpdate(offset, fire);
            level.levelEvent(1009, offset, 0);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.netherDecayEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_NETHER);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

