/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityAnimalSpawner
extends BlockEntityImpl
implements ITickableBlockEntity {
    private RecipeHolder<AnimalSpawnerRecipe> currentRecipe;
    private double spawnX;
    private double spawnZ;
    private int time;
    private Entity entityClient;

    public BlockEntityAnimalSpawner(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ANIMAL_SPAWNER, pos, state);
    }

    @Override
    public void tick() {
        block12: {
            block13: {
                block14: {
                    if (this.level.isClientSide) break block13;
                    if (this.level.getGameTime() % 10L != 0L) {
                        return;
                    }
                    if (!Multiblocks.ANIMAL_SPAWNER.isComplete(this.level, this.worldPosition)) {
                        if (this.currentRecipe != null) {
                            this.currentRecipe = null;
                            this.time = 0;
                            this.sendToClients();
                        }
                        return;
                    }
                    if (this.currentRecipe == null) break block14;
                    int drain = Mth.ceil((float)((float)((AnimalSpawnerRecipe)this.currentRecipe.value()).aura / (float)((AnimalSpawnerRecipe)this.currentRecipe.value()).time * 10.0f));
                    if (!this.canUseRightNow(drain)) {
                        return;
                    }
                    BlockPos spot = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 35, this.worldPosition);
                    IAuraChunk.getAuraChunk(this.level, spot).drainAura(spot, drain);
                    this.time += 10;
                    if (this.time < ((AnimalSpawnerRecipe)this.currentRecipe.value()).time) break block12;
                    Entity entity = ((AnimalSpawnerRecipe)this.currentRecipe.value()).makeEntity(this.level, BlockPos.containing((double)this.spawnX, (double)(this.worldPosition.getY() + 1), (double)this.spawnZ));
                    this.level.addFreshEntity(entity);
                    this.currentRecipe = null;
                    this.time = 0;
                    this.sendToClients();
                    break block12;
                }
                List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).inflate(2.0));
                for (RecipeHolder recipe : this.level.getRecipeManager().getRecipesFor(ModRecipes.ANIMAL_SPAWNER_TYPE, null, this.level)) {
                    ItemStack stack;
                    ItemEntity item2;
                    if (((AnimalSpawnerRecipe)recipe.value()).ingredients.size() != items.size()) continue;
                    ArrayList<Ingredient> required = new ArrayList<Ingredient>(((AnimalSpawnerRecipe)recipe.value()).ingredients);
                    Iterator iterator = items.iterator();
                    block1: while (iterator.hasNext() && (item2 = (ItemEntity)iterator.next()).isAlive() && !item2.hasPickUpDelay() && !(stack = item2.getItem()).isEmpty()) {
                        for (Ingredient ingredient : required) {
                            if (!ingredient.test(stack) || Helper.getIngredientAmount(ingredient) != stack.getCount()) continue;
                            required.remove(ingredient);
                            continue block1;
                        }
                    }
                    if (!required.isEmpty()) continue;
                    for (ItemEntity item2 : items) {
                        item2.remove(Entity.RemovalReason.KILLED);
                        PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)item2.getX(), (float)item2.getY(), (float)item2.getZ(), PacketParticles.Type.ANIMAL_SPAWNER, new int[0]));
                    }
                    this.currentRecipe = recipe;
                    this.spawnX = (double)this.worldPosition.getX() + 0.5 + (double)(this.level.random.nextFloat() * 4.0f) - 2.0;
                    this.spawnZ = (double)this.worldPosition.getZ() + 0.5 + (double)(this.level.random.nextFloat() * 4.0f) - 2.0;
                    this.sendToClients();
                    break block12;
                }
                break block12;
            }
            if (this.level.getGameTime() % 5L != 0L) {
                return;
            }
            if (this.currentRecipe == null) {
                this.entityClient = null;
                return;
            }
            NaturesAuraAPI.instance().spawnParticleStream((float)this.worldPosition.getX() + (float)this.level.random.nextGaussian() * 5.0f, (float)(this.worldPosition.getY() + 1) + this.level.random.nextFloat() * 5.0f, (float)this.worldPosition.getZ() + (float)this.level.random.nextGaussian() * 5.0f, (float)this.worldPosition.getX() + this.level.random.nextFloat(), (float)this.worldPosition.getY() + this.level.random.nextFloat(), (float)this.worldPosition.getZ() + this.level.random.nextFloat(), this.level.random.nextFloat() * 0.07f + 0.07f, IAuraType.forLevel(this.level).getColor(), this.level.random.nextFloat() + 0.5f);
            if (this.entityClient == null) {
                this.entityClient = ((AnimalSpawnerRecipe)this.currentRecipe.value()).makeEntity(this.level, BlockPos.ZERO);
                this.entityClient.setPos(this.spawnX, (double)(this.worldPosition.getY() + 1), this.spawnZ);
            }
            AABB bounds = this.entityClient.getBoundingBox();
            for (int i = this.level.random.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(bounds.minX + (double)this.level.random.nextFloat() * (bounds.maxX - bounds.minX), bounds.minY + (double)this.level.random.nextFloat() * (bounds.maxY - bounds.minY), bounds.minZ + (double)this.level.random.nextFloat() * (bounds.maxZ - bounds.minZ), 0.0, 0.0, 0.0, 3135699, 2.0f, 60, 0.0f, false, true);
            }
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.writeNBT(compound, type, registries);
        if (type != BlockEntityImpl.SaveType.BLOCK && this.currentRecipe != null) {
            compound.putString("recipe", this.currentRecipe.id().toString());
            compound.putDouble("spawn_x", this.spawnX);
            compound.putDouble("spawn_z", this.spawnZ);
            compound.putInt("time", this.time);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.readNBT(compound, type, registries);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            if (compound.contains("recipe")) {
                if (this.hasLevel()) {
                    ResourceLocation name = ResourceLocation.parse((String)compound.getString("recipe"));
                    this.currentRecipe = this.level.getRecipeManager().byKey(name).orElse(null);
                }
                this.spawnX = compound.getDouble("spawn_x");
                this.spawnZ = compound.getDouble("spawn_z");
                this.time = compound.getInt("time");
            } else {
                this.currentRecipe = null;
                this.time = 0;
            }
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

