/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.utils;

import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public final class ScreenUtils {
    private ScreenUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static void setTooltip(ItemStack stack) {
        ScreenUtils.setTooltip(stack, true);
    }

    public static void setTooltip(Component component) {
        ScreenUtils.setTooltip(List.of(component), true);
    }

    public static void setTooltip(List<Component> component) {
        ScreenUtils.setTooltip(component, true);
    }

    public static void setTooltip(ItemStack stack, boolean replace) {
        Minecraft mc = Minecraft.getInstance();
        Item.TooltipContext context = Item.TooltipContext.of((Level)mc.level);
        ScreenUtils.setTooltip(stack.getTooltipLines(context, (Player)mc.player, (TooltipFlag)(mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL)), replace);
    }

    public static void setTooltip(Component component, boolean replace) {
        ScreenUtils.setTooltip(List.of(component), replace);
    }

    public static void setTooltip(List<Component> component, boolean replace) {
        if (Minecraft.getInstance().screen != null) {
            ArrayList<FormattedCharSequence> formattedComponents = new ArrayList<FormattedCharSequence>(component.size());
            for (Component comp : component) {
                formattedComponents.add(comp.getVisualOrderText());
            }
            Minecraft.getInstance().screen.setTooltipForNextRenderPass(formattedComponents, DefaultTooltipPositioner.INSTANCE, replace);
        }
    }

    public static void clearTooltip() {
        ScreenUtils.setTooltip(List.of(), true);
    }

    public static void sendCommand(String command) {
        if (Minecraft.getInstance().getConnection() != null) {
            Minecraft.getInstance().getConnection().sendUnsignedCommand(command);
        }
    }

    public static void sendClick(int containerId, int buttonId) {
        if (Minecraft.getInstance().gameMode != null) {
            Minecraft.getInstance().gameMode.handleInventoryButtonClick(containerId, buttonId);
        }
    }

    public static boolean inBounds(ScreenRectangle rectangle, int x, int y) {
        return x >= rectangle.left() && x <= rectangle.right() && y >= rectangle.top() && y <= rectangle.bottom();
    }
}

