/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.register;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.danilppzz.potleaves.blocks.DesertPot;
import dev.danilppzz.potleaves.blocks.HangingPot;
import dev.danilppzz.potleaves.blocks.LargeWoodenPot;
import dev.danilppzz.potleaves.blocks.Pot;
import dev.danilppzz.potleaves.blocks.WoodenBox;
import dev.danilppzz.potleaves.blocks.WoodenPot;
import dev.danilppzz.potleaves.register.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"potleaves", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<WoodenBox> WOODEN_BOX = ModBlocks.registerBlock("wooden_box", () -> new WoodenBox(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.BAMBOO_WOOD)));
    public static final RegistrySupplier<LargeWoodenPot> LARGE_WOODEN_POT = ModBlocks.registerBlock("large_wooden_pot", () -> new LargeWoodenPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.BAMBOO_WOOD)));
    public static final RegistrySupplier<LargeWoodenPot> LARGE_LEAVE_WOODEN_POT = ModBlocks.registerBlock("large_leave_wooden_pot", () -> new LargeWoodenPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.BAMBOO_WOOD)));
    public static final RegistrySupplier<HangingPot> HANGING_POT = ModBlocks.registerBlock("hanging_pot", () -> new HangingPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.BAMBOO_WOOD)));
    public static final RegistrySupplier<HangingPot> BINDWEED_HANGING_POT = ModBlocks.registerBlock("bindweed_hanging_pot", () -> new HangingPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.BAMBOO_WOOD)));
    public static final RegistrySupplier<WoodenPot> WOODEN_POT = ModBlocks.registerBlock("wooden_pot", () -> new WoodenPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.BAMBOO_WOOD)));
    public static final RegistrySupplier<Pot> CACTUS_WOODEN_POT = ModBlocks.registerPot("cactus", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> PINK_CACTUS_WOODEN_POT = ModBlocks.registerPot("pink_cactus", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> SMALL_LEAVE_WOODEN_POT = ModBlocks.registerPot("small_leave", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> BIG_LEAVE_WOODEN_POT = ModBlocks.registerPot("big_leave", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> MINI_WOODEN_POT = ModBlocks.registerPot("mini_leave", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> ALOE_VERA_WOODEN_POT = ModBlocks.registerPot("aloe_vera", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> MUSA_WOODEN_POT = ModBlocks.registerPot("musa", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> BINDWEED_WOODEN_POT = ModBlocks.registerPot("bindweed", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> SAGEBRUSH_WOODEN_POT = ModBlocks.registerPot("sagebrush", Pot.Type.WOODEN);
    public static final RegistrySupplier<Pot> MARMOL_POT = ModBlocks.registerSinglePot("marmol_pot", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> CACTUS_MARMOL_POT = ModBlocks.registerPot("cactus", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> PINK_CACTUS_MARMOL_POT = ModBlocks.registerPot("pink_cactus", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> SMALL_LEAVE_MARMOL_POT = ModBlocks.registerPot("small_leave", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> BIG_LEAVE_MARMOL_POT = ModBlocks.registerPot("big_leave", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> MINI_MARMOL_POT = ModBlocks.registerPot("mini_leave", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> ALOE_VERA_MARMOL_POT = ModBlocks.registerPot("aloe_vera", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> MUSA_MARMOL_POT = ModBlocks.registerPot("musa", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> BINDWEED_MARMOL_POT = ModBlocks.registerPot("bindweed", Pot.Type.MARMOL);
    public static final RegistrySupplier<Pot> SAGEBRUSH_MARMOL_POT = ModBlocks.registerPot("sagebrush", Pot.Type.MARMOL);
    public static final RegistrySupplier<DesertPot> DESERT_POT = ModBlocks.registerDesertPot("pot", DesertPot.Type.DESERT);
    public static final RegistrySupplier<DesertPot> CACTUS_DESERT_POT = ModBlocks.registerDesertPot("cactus", DesertPot.Type.DESERT);

    private static RegistrySupplier<Pot> registerSinglePot(String name, Pot.Type type) {
        return ModBlocks.registerBlock(name, () -> new Pot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(type.soundType)));
    }

    private static RegistrySupplier<Pot> registerPot(String name, Pot.Type type) {
        return ModBlocks.registerBlock(name + "_" + type.extension, () -> new Pot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(type.soundType)));
    }

    private static RegistrySupplier<DesertPot> registerDesertPot(String name, DesertPot.Type type) {
        return ModBlocks.registerBlock(name + "_" + type.extension, () -> new DesertPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(type.soundType)));
    }

    private static RegistrySupplier<DesertPot> registerHangingPot(String name, DesertPot.Type type) {
        return ModBlocks.registerBlock(name + "_" + type.extension, () -> new DesertPot(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(type.soundType)));
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistrySupplier<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

