/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BaseScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected ResourceLocation TEXTURE;
    protected int textureWidth;
    protected int textureHeight;
    protected int widthExtra;
    protected int heightExtra;

    public BaseScreen(T abstractContainerMenu, Inventory inventory, Component component, int width, int height, int widthExtra, int heightExtra, String textureName) {
        super(abstractContainerMenu, inventory, component);
        this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"potleaves", (String)("textures/gui/" + textureName + ".png"));
        this.textureWidth = width;
        this.textureHeight = height;
        this.widthExtra = widthExtra;
        this.heightExtra = heightExtra;
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        int x = (this.width - this.textureWidth) / 2 + this.widthExtra;
        int y = (this.height - this.textureHeight) / 2 + this.heightExtra;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.textureWidth, this.textureHeight);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
    }
}

