/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.blocks;

import com.mojang.serialization.MapCodec;
import dev.danilppzz.potleaves.blockentity.WoodenPotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenPot
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    public static final BooleanProperty HAS_FLOWER = BooleanProperty.create((String)"has_flower");
    public static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
    public static final MapCodec<WoodenPot> CODEC = WoodenPot.simpleCodec(WoodenPot::new);

    public WoodenPot(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_FLOWER, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_FLOWER, FACING});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WoodenPotBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof WoodenPotBlockEntity) {
            WoodenPotBlockEntity potBE = (WoodenPotBlockEntity)blockEntity;
            potBE.getFlower();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockItem bi;
        Item item;
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof WoodenPotBlockEntity)) {
            return ItemInteractionResult.SUCCESS;
        }
        WoodenPotBlockEntity potBE = (WoodenPotBlockEntity)be;
        ItemStack flowerInPot = potBE.getFlower();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof FlowerBlock) {
            if (flowerInPot.isEmpty() && !level.isClientSide) {
                potBE.getFlower();
                stack.shrink(1);
                potBE.setChanged();
                level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                level.setBlock(pos, (BlockState)state.setValue((Property)HAS_FLOWER, (Comparable)Boolean.valueOf(true)), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stack.isEmpty() && !flowerInPot.isEmpty() && !level.isClientSide) {
            ItemStack extracted = potBE.getFlower();
            player.setItemInHand(hand, extracted);
            potBE.setChanged();
            level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_FLOWER, (Comparable)Boolean.valueOf(false)), 3);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

