/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.blocks;

import com.mojang.serialization.MapCodec;
import dev.danilppzz.potleaves.blocks.base.BlockEntityBase;
import dev.danilppzz.potleaves.register.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenBox
extends BlockEntityBase {
    private static final MapCodec<WoodenBox> CODEC = WoodenBox.simpleCodec(WoodenBox::new);

    public WoodenBox(BlockBehaviour.Properties properties) {
        super(properties.dynamicShape().noOcclusion());
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        if (direction != Direction.NORTH && direction != Direction.SOUTH) {
            return Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)7.0, (double)14.0);
        }
        return Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)7.0, (double)12.0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)ModBlockEntity.WOODEN_BOX.get()).create(blockPos, blockState);
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return !levelReader.getBlockState(blockPos.below()).isAir();
    }
}

