/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.blocks;

import dev.danilppzz.potleaves.blocks.base.PotBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class HangingPot
extends PotBase {
    public HangingPot(BlockBehaviour.Properties properties) {
        super(properties.dynamicShape().noOcclusion());
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos above = pos.above();
        BlockState stateAbove = world.getBlockState(above);
        Block blockAbove = stateAbove.getBlock();
        if (stateAbove.isFaceSturdy((BlockGetter)world, above, Direction.DOWN)) {
            return true;
        }
        return blockAbove instanceof FenceBlock || blockAbove instanceof WallBlock || blockAbove instanceof ChestBlock || blockAbove instanceof ChainBlock || blockAbove instanceof DecoratedPotBlock || blockAbove instanceof LightningRodBlock || blockAbove instanceof StainedGlassPaneBlock || blockAbove instanceof HopperBlock && stateAbove.getValue((Property)HopperBlock.FACING) == Direction.DOWN;
    }

    @Override
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }
}

