/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.blockentity.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.danilppzz.potleaves.blockentity.WoodenBoxBlockEntity;
import dev.danilppzz.potleaves.blocks.WoodenBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class WoodenBoxBlockEntityRenderer
implements BlockEntityRenderer<WoodenBoxBlockEntity> {
    public WoodenBoxBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(WoodenBoxBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        pose.pushPose();
        pose.translate(0.5, 0.25, 0.29);
        pose.scale(0.35f, 0.35f, 0.35f);
        float yRot = 0.0f;
        switch ((Direction)be.getBlockState().getValue((Property)WoodenBox.FACING)) {
            case NORTH: {
                yRot = 0.0f;
                break;
            }
            case EAST: {
                yRot = 90.0f;
                break;
            }
            case SOUTH: {
                yRot = 180.0f;
                break;
            }
            case WEST: {
                yRot = 270.0f;
            }
        }
        pose.mulPose(Axis.YP.rotationDegrees(yRot));
        for (int slot = 0; slot < 6; ++slot) {
            ItemStack stack = be.getItem(slot);
            if (stack.isEmpty()) continue;
            pose.pushPose();
            int row = slot / 3;
            int col = slot % 3;
            float spacing = 0.55f;
            float x = (float)(col - 1) * spacing;
            float z = (float)(row - 1) * spacing;
            Direction facing = (Direction)be.getBlockState().getValue((Property)WoodenBox.FACING);
            switch (facing) {
                case NORTH: {
                    boolean isVanilla;
                    Item block;
                    BlockItem bItem;
                    Item item = stack.getItem();
                    if (item instanceof BlockItem) {
                        bItem = (BlockItem)item;
                        block = bItem.getBlock();
                        isVanilla = BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace().equals("minecraft");
                        z += isVanilla ? 0.8f : 1.2f;
                        break;
                    }
                    z += 0.8f;
                    break;
                }
                case SOUTH: {
                    boolean isVanilla;
                    BlockItem bItem;
                    Item block = stack.getItem();
                    if (block instanceof BlockItem) {
                        bItem = (BlockItem)block;
                        isVanilla = BuiltInRegistries.BLOCK.getKey((Object)(block = bItem.getBlock())).getNamespace().equals("minecraft");
                        z -= isVanilla ? 0.35f : 0.0f;
                        break;
                    }
                    z -= 0.2f;
                    break;
                }
                case EAST: {
                    boolean isVanilla;
                    BlockItem bItem;
                    x -= 0.6f;
                    Item block = stack.getItem();
                    if (block instanceof BlockItem) {
                        bItem = (BlockItem)block;
                        isVanilla = BuiltInRegistries.BLOCK.getKey((Object)(block = bItem.getBlock())).getNamespace().equals("minecraft");
                        z += isVanilla ? 0.3f : 0.6f;
                        break;
                    }
                    z += 0.35f;
                    break;
                }
                case WEST: {
                    boolean isVanilla;
                    BlockItem bItem;
                    x += 0.6f;
                    Item block = stack.getItem();
                    if (block instanceof BlockItem) {
                        bItem = (BlockItem)block;
                        isVanilla = BuiltInRegistries.BLOCK.getKey((Object)(block = bItem.getBlock())).getNamespace().equals("minecraft");
                        z += isVanilla ? 0.3f : 0.6f;
                        break;
                    }
                    z += 0.35f;
                }
            }
            pose.translate(x, 0.0f, z);
            renderer.renderStatic(stack, ItemDisplayContext.FIXED, this.getLight(be), OverlayTexture.NO_OVERLAY, pose, buffer, be.getLevel(), slot);
            pose.popPose();
        }
        pose.popPose();
    }

    private int getLight(WoodenBoxBlockEntity be) {
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        return LightTexture.pack((int)level.getBrightness(LightLayer.BLOCK, pos), (int)level.getBrightness(LightLayer.SKY, pos));
    }
}

