/*
 * Decompiled with CFR 0.152.
 */
package dev.danilppzz.potleaves.blockentity;

import dev.danilppzz.potleaves.register.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WoodenPotBlockEntity
extends BlockEntity {
    private ItemStack flower = ItemStack.EMPTY;

    public WoodenPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.WOODEN_POT.get(), pos, state);
    }

    public ItemStack getFlower() {
        return this.flower;
    }

    public void setFlower(ItemStack stack) {
        this.flower = stack.copy();
        this.setChanged();
        if (!this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void clearFlower() {
        this.flower = ItemStack.EMPTY;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.flower.isEmpty()) {
            tag.put("Flower", this.flower.save(registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Flower")) {
            this.flower = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("Flower")).orElse(ItemStack.EMPTY);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

