/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.datagen.recipes;

import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.items.tools.basetools.BaseAxe;
import com.direwolf20.justdirethings.common.items.tools.basetools.BasePickaxe;
import com.direwolf20.justdirethings.common.items.tools.basetools.BaseShovel;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class PaxelRecipe
implements SmithingRecipe {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;

    public PaxelRecipe(Ingredient template, Ingredient base, Ingredient addition, ItemStack result) {
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    public boolean matches(SmithingRecipeInput p_346082_, Level p_345460_) {
        return this.template.test(p_346082_.template()) && this.base.test(p_346082_.base()) && this.addition.test(p_346082_.addition());
    }

    public ItemStack assemble(SmithingRecipeInput smithingRecipeInput, HolderLookup.Provider provider) {
        Object ability3;
        Object ability22;
        Object object;
        ItemStack pickaxe = smithingRecipeInput.template();
        ItemStack axe = smithingRecipeInput.base();
        ItemStack shovel = smithingRecipeInput.addition();
        ItemStack result = this.getResultItem(provider);
        if (this.isTemplateIngredient(pickaxe) && (object = pickaxe.getItem()) instanceof ToggleableTool) {
            ToggleableTool pickaxetoggleableTool = (ToggleableTool)object;
            for (Object ability22 : pickaxetoggleableTool.getAbilities()) {
                if (!ToggleableTool.hasUpgrade(pickaxe, ability22)) continue;
                result.set((Supplier)JustDireDataComponents.ABILITY_UPGRADE_INSTALLS.get(ability22), (Object)true);
            }
        } else {
            return ItemStack.EMPTY;
        }
        object = pickaxe.getComponentsPatch().get(DataComponents.ENCHANTMENTS);
        if (this.isBaseIngredient(axe) && (ability22 = axe.getItem()) instanceof ToggleableTool) {
            ToggleableTool axetoggleableTool = (ToggleableTool)ability22;
            for (Object ability3 : axetoggleableTool.getAbilities()) {
                if (!ToggleableTool.hasUpgrade(axe, ability3)) continue;
                result.set((Supplier)JustDireDataComponents.ABILITY_UPGRADE_INSTALLS.get(ability3), (Object)true);
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (this.isAdditionIngredient(shovel) && (ability3 = shovel.getItem()) instanceof ToggleableTool) {
            ToggleableTool shoveltoggleableTool = (ToggleableTool)ability3;
            for (Ability ability4 : shoveltoggleableTool.getAbilities()) {
                if (!ToggleableTool.hasUpgrade(shovel, ability4)) continue;
                result.set((Supplier)JustDireDataComponents.ABILITY_UPGRADE_INSTALLS.get((Object)ability4), (Object)true);
            }
        } else {
            return ItemStack.EMPTY;
        }
        ItemEnchantments pickaxeEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)pickaxe);
        ItemEnchantments axeEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)axe);
        ItemEnchantments shovelEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)shovel);
        EnchantmentHelper.updateEnchantments((ItemStack)result, enchantments -> {
            HashSet appliedEnchantments = new HashSet();
            BiConsumer<ItemEnchantments, String> addEnchantments = (itemEnchantments, toolName) -> itemEnchantments.entrySet().forEach(entry -> {
                Holder enchantment = (Holder)entry.getKey();
                int level = entry.getIntValue();
                if (appliedEnchantments.stream().allMatch(existing -> Enchantment.areCompatible((Holder)existing, (Holder)enchantment))) {
                    enchantments.set(enchantment, level);
                    appliedEnchantments.add(enchantment);
                } else {
                    System.out.println("Skipping incompatible enchantment from " + toolName + ": " + String.valueOf(enchantment));
                }
            });
            addEnchantments.accept(pickaxeEnchantments, "pickaxe");
            addEnchantments.accept(axeEnchantments, "axe");
            addEnchantments.accept(shovelEnchantments, "shovel");
        });
        return result;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean isTemplateIngredient(ItemStack stack) {
        return stack.getItem() instanceof BasePickaxe;
    }

    public boolean isBaseIngredient(ItemStack stack) {
        return stack.getItem() instanceof BaseAxe;
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return stack.getItem() instanceof BaseShovel;
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(Ingredient::hasNoItems);
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.PAXEL_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<PaxelRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"paxel");
        private static final MapCodec<PaxelRecipe> CODEC = RecordCodecBuilder.mapCodec(p_311734_ -> p_311734_.group((App)Ingredient.CODEC.fieldOf("template").forGetter(p_301070_ -> p_301070_.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(p_300969_ -> p_300969_.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(p_300977_ -> p_300977_.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_300935_ -> p_300935_.result)).apply((Applicative)p_311734_, PaxelRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PaxelRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PaxelRecipe::getTemplate, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PaxelRecipe::getBase, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, PaxelRecipe::getAddition, (StreamCodec)ItemStack.STREAM_CODEC, PaxelRecipe::getResult, PaxelRecipe::new);

        public MapCodec<PaxelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PaxelRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

