/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.colour.EnumColour;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.raytracer.SubHitBlockHitResult;
import codechicken.lib.util.ItemUtils;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEnderStorage
extends BaseEntityBlock {
    public BlockEnderStorage(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void playerDestroy(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(worldIn, player, pos, state, te, stack);
        worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileFrequencyOwner tile = (TileFrequencyOwner)((Object)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY));
        if (tile != null) {
            drops.add(this.createItem(tile.getFrequency()));
            if (EnderStorageConfig.anarchyMode && tile.getFrequency().hasOwner()) {
                drops.add(EnderStorageConfig.getPersonalItem().copy());
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult rayTraceResult, LevelReader world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileFrequencyOwner) {
            TileFrequencyOwner tile = (TileFrequencyOwner)blockEntity;
            return this.createItem(tile.getFrequency());
        }
        return ItemStack.EMPTY;
    }

    private ItemStack createItem(Frequency freq) {
        if (EnderStorageConfig.anarchyMode) {
            freq = freq.withoutOwner();
        }
        ItemStack stack = new ItemStack((ItemLike)this, 1);
        freq.writeToStack(stack);
        return stack;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult clientHit) {
        EnumColour dye;
        ItemStack item;
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (!(tile instanceof TileFrequencyOwner)) {
            return ItemInteractionResult.FAIL;
        }
        TileFrequencyOwner owner = (TileFrequencyOwner)tile;
        BlockHitResult rawHit = RayTracer.retrace((Player)player);
        if (!(rawHit instanceof SubHitBlockHitResult)) {
            return ItemInteractionResult.FAIL;
        }
        SubHitBlockHitResult hit = (SubHitBlockHitResult)rawHit;
        if (hit.subHit == 4) {
            ItemStack item2 = player.getInventory().getSelected();
            if (player.isCrouching() && owner.getFrequency().hasOwner()) {
                if (!player.getAbilities().instabuild && !player.getInventory().add(EnderStorageConfig.getPersonalItem().copy())) {
                    return ItemInteractionResult.FAIL;
                }
                owner.setFreq(owner.getFrequency().withoutOwner());
                return ItemInteractionResult.SUCCESS;
            }
            if (!item2.isEmpty() && ItemUtils.areStacksSameType((ItemStack)item2, (ItemStack)EnderStorageConfig.getPersonalItem()) && !owner.getFrequency().hasOwner()) {
                owner.setFreq(owner.getFrequency().withOwner(player));
                if (!player.getAbilities().instabuild) {
                    item2.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else if (hit.subHit >= 1 && hit.subHit <= 3 && !(item = player.getInventory().getSelected()).isEmpty() && (dye = EnumColour.fromDyeStack((ItemStack)item)) != null) {
            EnumColour[] colours = new EnumColour[]{null, null, null};
            if (colours[hit.subHit - 1] == dye) {
                return ItemInteractionResult.FAIL;
            }
            colours[hit.subHit - 1] = dye;
            owner.setFreq(owner.getFrequency().withColours(colours));
            if (!player.getAbilities().instabuild) {
                item.shrink(1);
            }
            return ItemInteractionResult.FAIL;
        }
        return !player.isCrouching() && owner.activate(player, hit.subHit, hand) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileFrequencyOwner) {
            TileFrequencyOwner tile = (TileFrequencyOwner)blockEntity;
            tile.onPlaced(placer);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileFrequencyOwner) {
            return ((TileFrequencyOwner)tile).getLightValue();
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileFrequencyOwner && ((TileFrequencyOwner)tile).redstoneInteraction();
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileFrequencyOwner ? ((TileFrequencyOwner)tile).comparatorOutput() : 0;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileFrequencyOwner) {
            ((TileFrequencyOwner)tile).rotate();
        }
        return state;
    }

    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, worldIn, pos, eventID, eventParam);
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        return tileentity != null && tileentity.triggerEvent(eventID, eventParam);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new UnsupportedOperationException();
    }
}

