/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.lib.util.DimensionId;

public record DimPos(int posX, int posY, int posZ, ResourceKey<Level> dimension) {
    public static final Codec<DimPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(DimPos::getX), (App)Codec.INT.fieldOf("y").forGetter(DimPos::getY), (App)Codec.INT.fieldOf("z").forGetter(DimPos::getZ), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(DimPos::getDimension)).apply((Applicative)instance, DimPos::of));
    public static final StreamCodec<RegistryFriendlyByteBuf, DimPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DimPos::getX, (StreamCodec)ByteBufCodecs.VAR_INT, DimPos::getY, (StreamCodec)ByteBufCodecs.VAR_INT, DimPos::getZ, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), DimPos::getDimension, DimPos::of);
    public static final DimPos ZERO = new DimPos(0, 0, 0, (ResourceKey<Level>)Level.OVERWORLD);

    private DimPos(BlockPos pos, ResourceKey<Level> dimension) {
        this(pos.getX(), pos.getY(), pos.getZ(), dimension);
    }

    public static DimPos of(BlockPos pos, ResourceKey<Level> dimension) {
        return new DimPos(pos, dimension);
    }

    public static DimPos of(int x, int y, int z, ResourceKey<Level> dimension) {
        return new DimPos(x, y, z, dimension);
    }

    public static DimPos of(Entity entity) {
        return new DimPos(entity.blockPosition(), (ResourceKey<Level>)entity.level().dimension());
    }

    @Deprecated(forRemoval=true)
    public int getX() {
        return this.posX;
    }

    @Deprecated(forRemoval=true)
    public int getY() {
        return this.posY;
    }

    @Deprecated(forRemoval=true)
    public int getZ() {
        return this.posZ;
    }

    @Deprecated(forRemoval=true)
    public DimensionId getDimensionId() {
        return DimensionId.fromId(this.dimension);
    }

    @Deprecated(forRemoval=true)
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public static DimPos deserializeNbt(CompoundTag tag) {
        return DimPos.of(tag.getInt("posX"), tag.getInt("posY"), tag.getInt("posZ"), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("dim"))));
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("posX", this.posX);
        tag.putInt("posY", this.posY);
        tag.putInt("posZ", this.posZ);
        tag.putString("dim", this.dimension.location().toString());
        return tag;
    }

    public Optional<Level> getPosLevel(Level anyLevel) {
        MinecraftServer server = anyLevel.getServer();
        if (server == null) {
            return Optional.empty();
        }
        ServerLevel posLevel = server.getLevel(this.dimension);
        return Optional.ofNullable(posLevel);
    }

    public BlockPos getPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public Vec3 getPosCentered(double yOffset) {
        return new Vec3((double)this.posX + 0.5, (double)this.posY + yOffset, (double)this.posZ + 0.5);
    }

    public DimPos offset(Direction facing, int n) {
        if (n == 0) {
            return this;
        }
        return new DimPos(this.posX + facing.getStepX() * n, this.posY + facing.getStepY() * n, this.posZ + facing.getStepZ() * n, this.dimension);
    }

    @Override
    public String toString() {
        return String.format("(%d, %d, %s) in %s", this.posX, this.posY, this.posZ, this.dimension.location());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DimPos) {
            DimPos pos = (DimPos)other;
            return pos.dimension.location().equals((Object)this.dimension.location()) && pos.posX == this.posX && pos.posY == this.posY && pos.posZ == this.posZ;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dimension.location().hashCode();
    }
}

