/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.screen.custom;

import com.blocklogic.agritechevolved.compat.jei.ATEJeiPlugin;
import com.blocklogic.agritechevolved.compat.jei.CompostRecipeCategory;
import com.blocklogic.agritechevolved.screen.custom.ComposterMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ComposterScreen
extends AbstractContainerScreen<ComposterMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"textures/gui/composter_gui.png");

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY -= 2;
    }

    public ComposterScreen(ComposterMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.imageWidth = 176;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        int progress = ((ComposterMenu)this.menu).getProgress();
        int maxProgress = ((ComposterMenu)this.menu).getMaxProgress();
        if (maxProgress > 0) {
            float progressPercentage = (float)progress / (float)maxProgress;
            int progressBarHeight = (int)(52.0f * progressPercentage);
            int progressBarY = y + 15 + 52 - progressBarHeight;
            guiGraphics.blit(GUI_TEXTURE, x + 85, progressBarY, 186, 52 - progressBarHeight, 6, progressBarHeight);
        }
        int energyStored = ((ComposterMenu)this.menu).getEnergyStored();
        int maxEnergy = ((ComposterMenu)this.menu).getMaxEnergyStored();
        if (maxEnergy > 0) {
            float energyPercentage = (float)energyStored / (float)maxEnergy;
            int energyBarHeight = (int)(52.0f * energyPercentage);
            int energyBarY = y + 15 + 52 - energyBarHeight;
            guiGraphics.blit(GUI_TEXTURE, x + 158, energyBarY, 176, 52 - energyBarHeight, 10, energyBarHeight);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        ArrayList<MutableComponent> tooltip;
        super.renderTooltip(guiGraphics, x, y);
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        if (x >= guiX + 85 && x <= guiX + 85 + 6 && y >= guiY + 15 && y <= guiY + 15 + 52) {
            tooltip = new ArrayList<MutableComponent>();
            int progress = ((ComposterMenu)this.menu).getProgress();
            int maxProgress = ((ComposterMenu)this.menu).getMaxProgress();
            int organicItems = ((ComposterMenu)this.menu).getOrganicItemsCollected();
            int requiredItems = ((ComposterMenu)this.menu).getRequiredOrganicItems();
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.composting_progress").withStyle(ChatFormatting.GREEN));
            if (maxProgress > 0) {
                float progressPercentage = (float)progress / (float)maxProgress * 100.0f;
                tooltip.add(Component.literal((String)String.format("%.1f%%", Float.valueOf(progressPercentage))).withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add(Component.literal((String)"0.0%").withStyle(ChatFormatting.GREEN));
            }
            tooltip.add(Component.literal((String)String.format("Organic Items: %d/%d", organicItems, requiredItems)).withStyle(ChatFormatting.GRAY));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.view_recipes").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            guiGraphics.renderComponentTooltip(this.font, tooltip, x, y);
        }
        if (x >= guiX + 158 && x <= guiX + 158 + 10 && y >= guiY + 15 && y <= guiY + 15 + 52) {
            tooltip = new ArrayList();
            int energyStored = ((ComposterMenu)this.menu).getEnergyStored();
            int maxEnergy = ((ComposterMenu)this.menu).getMaxEnergyStored();
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.stored_energy").withStyle(ChatFormatting.YELLOW));
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            String energyText = numberFormat.format(energyStored) + " / " + numberFormat.format(maxEnergy) + " RF";
            tooltip.add(Component.literal((String)energyText).withStyle(ChatFormatting.GREEN));
            if (maxEnergy > 0) {
                float energyPercentage = (float)energyStored / (float)maxEnergy * 100.0f;
                tooltip.add(Component.literal((String)String.format("%.1f%%", Float.valueOf(energyPercentage))).withStyle(ChatFormatting.GRAY));
            }
            guiGraphics.renderComponentTooltip(this.font, tooltip, x, y);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int guiX = (this.width - this.imageWidth) / 2;
            int guiY = (this.height - this.imageHeight) / 2;
            if (mouseX >= (double)(guiX + 85) && mouseX <= (double)(guiX + 85 + 6) && mouseY >= (double)(guiY + 15) && mouseY <= (double)(guiY + 15 + 52)) {
                IJeiRuntime runtime;
                if (this.minecraft != null && this.minecraft.player != null && (runtime = ATEJeiPlugin.getJeiRuntime()) != null) {
                    runtime.getRecipesGui().showTypes(List.of(CompostRecipeCategory.COMPOST_RECIPE_TYPE));
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

