/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.screen.custom;

import com.blocklogic.agritechevolved.block.ATEBlocks;
import com.blocklogic.agritechevolved.block.entity.ComposterBlockEntity;
import com.blocklogic.agritechevolved.config.CompostableConfig;
import com.blocklogic.agritechevolved.screen.ATEMenuTypes;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ComposterMenu
extends AbstractContainerMenu {
    public final ComposterBlockEntity blockEntity;
    private final Level level;
    private int lastEnergyStored = 0;
    private int lastProgress = 0;
    private static final int INPUT_SLOTS_START = 0;
    private static final int INPUT_SLOTS_COUNT = 12;
    private static final int OUTPUT_SLOTS_START = 12;
    private static final int OUTPUT_SLOTS_COUNT = 3;
    private static final int MODULE_SLOT = 15;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 16;

    public ComposterMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public ComposterMenu(int containerId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)ATEMenuTypes.COMPOSTER_MENU.get(), containerId);
        this.blockEntity = (ComposterBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        int inputSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                this.addSlot((Slot)new CompostableInputSlot((IItemHandler)this.blockEntity.inventory, inputSlotIndex++, 8 + col * 18, 15 + row * 18));
            }
        }
        int outputSlotIndex = 12;
        for (int row = 0; row < 3; ++row) {
            this.addSlot((Slot)new OutputOnlySlot((IItemHandler)this.blockEntity.inventory, outputSlotIndex++, 98, 15 + row * 18));
        }
        this.addSlot((Slot)new ModuleSlot((IItemHandler)this.blockEntity.inventory, 15, 134, 15));
        this.addDataSlots();
    }

    private void addDataSlots() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return ComposterMenu.this.blockEntity.getEnergyStored();
            }

            public void set(int value) {
                ComposterMenu.this.lastEnergyStored = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return ComposterMenu.this.blockEntity.getProgress();
            }

            public void set(int value) {
                ComposterMenu.this.lastProgress = value;
            }
        });
    }

    public int getEnergyStored() {
        return this.level.isClientSide ? this.lastEnergyStored : this.blockEntity.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.blockEntity.getMaxEnergyStored();
    }

    public int getProgress() {
        return this.level.isClientSide ? this.lastProgress : this.blockEntity.getProgress();
    }

    public int getMaxProgress() {
        return this.blockEntity.getMaxProgress();
    }

    public int getOrganicItemsCollected() {
        return this.blockEntity.getOrganicItemsCollected();
    }

    public int getRequiredOrganicItems() {
        return this.blockEntity.getRequiredOrganicItems();
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            String sourceItemId = RegistryHelper.getItemId(sourceStack);
            if (CompostableConfig.isCompostable(sourceItemId) ? !this.moveItemStackTo(sourceStack, 36, 48, false) : (sourceItemId.equals("agritechevolved:sm_mk1") || sourceItemId.equals("agritechevolved:sm_mk2") || sourceItemId.equals("agritechevolved:sm_mk3") ? !this.moveItemStackTo(sourceStack, 51, 52, false) : !this.moveItemStackTo(sourceStack, 36, 52, false))) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 52) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return ComposterMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)ATEBlocks.COMPOSTER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 81 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 140));
        }
    }

    private static class CompostableInputSlot
    extends SlotItemHandler {
        public CompostableInputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            String itemId = RegistryHelper.getItemId(stack);
            return CompostableConfig.isCompostable(itemId);
        }
    }

    private static class OutputOnlySlot
    extends SlotItemHandler {
        public OutputOnlySlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }

    private static class ModuleSlot
    extends SlotItemHandler {
        public ModuleSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            String itemId = RegistryHelper.getItemId(stack);
            return itemId.equals("agritechevolved:sm_mk1") || itemId.equals("agritechevolved:sm_mk2") || itemId.equals("agritechevolved:sm_mk3");
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

