/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.screen.custom;

import com.blocklogic.agritechevolved.screen.custom.CapacitorMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CapacitorScreen
extends AbstractContainerScreen<CapacitorMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"textures/gui/capacitor_gui.png");

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY -= 2;
    }

    public CapacitorScreen(CapacitorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 151;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int fillWidth;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        int energyStored = ((CapacitorMenu)this.menu).getEnergyStored();
        int maxEnergyStored = ((CapacitorMenu)this.menu).getMaxEnergyStored();
        if (maxEnergyStored > 0 && (fillWidth = (int)(160.0 * (double)energyStored / (double)maxEnergyStored)) > 0) {
            guiGraphics.blit(GUI_TEXTURE, x + 8, y + 15, 0, 151, fillWidth, 34);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> tooltip;
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (mouseX >= x + 8 && mouseX <= x + 168 && mouseY >= y + 15 && mouseY <= y + 49) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            ArrayList<MutableComponent> tooltip2 = new ArrayList<MutableComponent>();
            int energyStored = ((CapacitorMenu)this.menu).getEnergyStored();
            int maxEnergyStored = ((CapacitorMenu)this.menu).getMaxEnergyStored();
            int transferRate = ((CapacitorMenu)this.menu).getTransferRate();
            String tierName = ((CapacitorMenu)this.menu).getTierName();
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.title", (Object[])new Object[]{tierName}).withStyle(ChatFormatting.GOLD));
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.energy_storage").withStyle(ChatFormatting.YELLOW));
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.energy", (Object[])new Object[]{numberFormat.format(energyStored), numberFormat.format(maxEnergyStored)}).withStyle(ChatFormatting.WHITE));
            double percentage = maxEnergyStored > 0 ? (double)energyStored * 100.0 / (double)maxEnergyStored : 0.0;
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.energy_percentage", (Object[])new Object[]{String.format("%.1f", percentage)}).withStyle(ChatFormatting.GRAY));
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.transfer_rate", (Object[])new Object[]{numberFormat.format(transferRate)}).withStyle(ChatFormatting.AQUA));
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.connects_all_sides").withStyle(ChatFormatting.GREEN));
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.except_bottom").withStyle(ChatFormatting.DARK_GREEN));
            guiGraphics.renderComponentTooltip(this.font, tooltip2, mouseX, mouseY);
        }
        if (mouseX >= x + 8 && mouseX <= x + 168 && mouseY >= y + 6 && mouseY <= y + 14) {
            tooltip = new ArrayList<MutableComponent>();
            String tierName = ((CapacitorMenu)this.menu).getTierName();
            int transferRate = ((CapacitorMenu)this.menu).getTransferRate();
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.title", (Object[])new Object[]{tierName}).withStyle(ChatFormatting.GOLD));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.description").withStyle(ChatFormatting.YELLOW));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.max_transfer", (Object[])new Object[]{NumberFormat.getNumberInstance(Locale.US).format(transferRate)}).withStyle(ChatFormatting.AQUA));
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (mouseX >= x + 8 && mouseX <= x + 168 && mouseY >= y + 50 && mouseY <= y + 65) {
            tooltip = new ArrayList();
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.information").withStyle(ChatFormatting.GOLD));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.info_stores").withStyle(ChatFormatting.GRAY));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.info_balances").withStyle(ChatFormatting.GRAY));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.capacitor.info_automatic").withStyle(ChatFormatting.GRAY));
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        int energyStored = ((CapacitorMenu)this.menu).getEnergyStored();
        int maxEnergyStored = ((CapacitorMenu)this.menu).getMaxEnergyStored();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        MutableComponent energyText = Component.literal((String)(numberFormat.format(energyStored) + " RF"));
        int energyWidth = this.font.width((FormattedText)energyText);
        int bufferCenterX = 88;
        int bufferCenterY = 24;
        guiGraphics.drawString(this.font, (Component)energyText, bufferCenterX - energyWidth / 2, bufferCenterY, 0xFFFFFF, true);
        if (maxEnergyStored > 0) {
            double percentage = (double)energyStored * 100.0 / (double)maxEnergyStored;
            MutableComponent percentText = Component.literal((String)String.format("%.1f%%", percentage));
            int percentWidth = this.font.width((FormattedText)percentText);
            guiGraphics.drawString(this.font, (Component)percentText, bufferCenterX - percentWidth / 2, bufferCenterY + 10, 0xCCCCCC, true);
        }
    }
}

