/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.screen.custom;

import com.blocklogic.agritechevolved.screen.custom.BiomassBurnerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BiomassBurnerScreen
extends AbstractContainerScreen<BiomassBurnerMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"textures/gui/burner_gui.png");

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        this.titleLabelY -= 2;
    }

    public BiomassBurnerScreen(BiomassBurnerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.imageWidth = 176;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int energyHeight;
        int progressWidth;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        int progress = ((BiomassBurnerMenu)this.menu).getProgress();
        int maxProgress = ((BiomassBurnerMenu)this.menu).getMaxProgress();
        if (maxProgress > 0 && (progressWidth = (int)(52.0 * (double)progress / (double)maxProgress)) > 0) {
            guiGraphics.blit(GUI_TEXTURE, x + 62, y + 59, 0, 166, progressWidth, 6);
        }
        int energyStored = ((BiomassBurnerMenu)this.menu).getEnergyStored();
        int maxEnergyStored = ((BiomassBurnerMenu)this.menu).getMaxEnergyStored();
        if (maxEnergyStored > 0 && (energyHeight = (int)(52.0 * (double)energyStored / (double)maxEnergyStored)) > 0) {
            int startY = y + 15 + (52 - energyHeight);
            guiGraphics.blit(GUI_TEXTURE, x + 158, startY, 176, 52 - energyHeight, 10, energyHeight);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> tooltip;
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (mouseX >= x + 158 && mouseX <= x + 168 && mouseY >= y + 15 && mouseY <= y + 67) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            ArrayList<MutableComponent> tooltip2 = new ArrayList<MutableComponent>();
            int energyStored = ((BiomassBurnerMenu)this.menu).getEnergyStored();
            int maxEnergyStored = ((BiomassBurnerMenu)this.menu).getMaxEnergyStored();
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.burner.energy", (Object[])new Object[]{numberFormat.format(energyStored), numberFormat.format(maxEnergyStored)}).withStyle(ChatFormatting.YELLOW));
            double percentage = maxEnergyStored > 0 ? (double)energyStored * 100.0 / (double)maxEnergyStored : 0.0;
            tooltip2.add(Component.translatable((String)"tooltip.agritechevolved.burner.energy_percentage", (Object[])new Object[]{String.format("%.1f", percentage)}).withStyle(ChatFormatting.GRAY));
            guiGraphics.renderComponentTooltip(this.font, tooltip2, mouseX, mouseY);
        }
        if (mouseX >= x + 62 && mouseX <= x + 114 && mouseY >= y + 58 && mouseY <= y + 64) {
            tooltip = new ArrayList<MutableComponent>();
            int progress = ((BiomassBurnerMenu)this.menu).getProgress();
            int maxProgress = ((BiomassBurnerMenu)this.menu).getMaxProgress();
            if (maxProgress > 0) {
                double percentage = (double)progress * 100.0 / (double)maxProgress;
                int remainingTicks = maxProgress - progress;
                double remainingSeconds = (double)remainingTicks / 20.0;
                tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.burning_progress").withStyle(ChatFormatting.GOLD));
                tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.progress_percentage", (Object[])new Object[]{String.format("%.1f", percentage)}).withStyle(ChatFormatting.YELLOW));
                tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.time_remaining", (Object[])new Object[]{String.format("%.1f", remainingSeconds)}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.no_fuel").withStyle(ChatFormatting.RED));
                tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.insert_fuel").withStyle(ChatFormatting.GRAY));
            }
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
        if (mouseX >= x + 79 && mouseX <= x + 97 && mouseY >= y + 31 && mouseY <= y + 49 && ((BiomassBurnerMenu)this.menu).blockEntity.inventory.getStackInSlot(0).isEmpty()) {
            tooltip = new ArrayList();
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.fuel_slot").withStyle(ChatFormatting.GOLD));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.accepts").withStyle(ChatFormatting.GRAY));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.accepts_biomass").withStyle(ChatFormatting.GREEN));
            tooltip.add(Component.translatable((String)"tooltip.agritechevolved.burner.accepts_compacted_biomass").withStyle(ChatFormatting.GREEN));
            guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }
}

