/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.recipe;

import com.blocklogic.agritechevolved.recipe.DurabilityShapelessRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class DurabilityShapelessRecipeSerializer
implements RecipeSerializer<DurabilityShapelessRecipe> {
    public static final MapCodec<DurabilityShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(DurabilityShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").forGetter(DurabilityShapelessRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(DurabilityShapelessRecipe::getIngredients), (App)Ingredient.CODEC_NONEMPTY.fieldOf("tool").forGetter(DurabilityShapelessRecipe::getToolIngredient), (App)Codec.INT.fieldOf("durability_per_item").forGetter(DurabilityShapelessRecipe::getDurabilityPerItem)).apply((Applicative)instance, (group, category, result, ingredients, tool, durability) -> {
        NonNullList nonNullIngredients = NonNullList.create();
        nonNullIngredients.addAll((Collection)ingredients);
        return new DurabilityShapelessRecipe((String)group, (CraftingBookCategory)category, (ItemStack)result, (NonNullList<Ingredient>)nonNullIngredients, (Ingredient)tool, (int)durability);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, DurabilityShapelessRecipe> STREAM_CODEC = StreamCodec.of(DurabilityShapelessRecipeSerializer::toNetwork, DurabilityShapelessRecipeSerializer::fromNetwork);

    public MapCodec<DurabilityShapelessRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, DurabilityShapelessRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, DurabilityShapelessRecipe recipe) {
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)recipe.category());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
        buffer.writeVarInt(recipe.getIngredients().size());
        for (Ingredient ingredient : recipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getToolIngredient());
        buffer.writeVarInt(recipe.getDurabilityPerItem());
    }

    private static DurabilityShapelessRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        int ingredientCount = buffer.readVarInt();
        NonNullList ingredients = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
        }
        Ingredient tool = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        int durabilityPerItem = buffer.readVarInt();
        return new DurabilityShapelessRecipe(group, category, result, (NonNullList<Ingredient>)ingredients, tool, durabilityPerItem);
    }
}

