/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.datagen;

import com.blocklogic.agritechevolved.recipe.DurabilityShapelessRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class DurabilityShapelessRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private Ingredient toolIngredient = Ingredient.EMPTY;
    private int durabilityPerItem = 1;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private CraftingBookCategory category = CraftingBookCategory.MISC;

    public DurabilityShapelessRecipeBuilder(ItemLike result, int count) {
        this.result = new ItemStack(result, count);
    }

    public static DurabilityShapelessRecipeBuilder shapeless(ItemLike result) {
        return new DurabilityShapelessRecipeBuilder(result, 1);
    }

    public static DurabilityShapelessRecipeBuilder shapeless(ItemLike result, int count) {
        return new DurabilityShapelessRecipeBuilder(result, count);
    }

    public DurabilityShapelessRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public DurabilityShapelessRecipeBuilder requires(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public DurabilityShapelessRecipeBuilder requires(Ingredient ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public DurabilityShapelessRecipeBuilder requires(TagKey<Item> tag) {
        this.ingredients.add((Object)Ingredient.of(tag));
        return this;
    }

    public DurabilityShapelessRecipeBuilder tool(ItemLike tool) {
        this.toolIngredient = Ingredient.of((ItemLike[])new ItemLike[]{tool});
        return this;
    }

    public DurabilityShapelessRecipeBuilder tool(Ingredient tool) {
        this.toolIngredient = tool;
        return this;
    }

    public DurabilityShapelessRecipeBuilder durabilityPerItem(int durability) {
        this.durabilityPerItem = durability;
        return this;
    }

    public DurabilityShapelessRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public DurabilityShapelessRecipeBuilder category(CraftingBookCategory category) {
        this.category = category;
        return this;
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        this.ensureValid(id);
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        DurabilityShapelessRecipe recipe = new DurabilityShapelessRecipe(this.group == null ? "" : this.group, this.category, this.result, this.ingredients, this.toolIngredient, this.durabilityPerItem);
        String categoryPath = switch (this.category) {
            default -> throw new MatchException(null, null);
            case CraftingBookCategory.BUILDING -> "building_blocks";
            case CraftingBookCategory.REDSTONE -> "redstone";
            case CraftingBookCategory.EQUIPMENT -> "equipment";
            case CraftingBookCategory.MISC -> "misc";
        };
        output.accept(id, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/" + categoryPath + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
        if (this.toolIngredient.isEmpty()) {
            throw new IllegalStateException("No tool specified for recipe " + String.valueOf(id));
        }
    }
}

