/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.datagen;

import com.blocklogic.agritechevolved.datagen.ATEBlockStateProvider;
import com.blocklogic.agritechevolved.datagen.ATEBlockTagProvider;
import com.blocklogic.agritechevolved.datagen.ATEItemModelProvider;
import com.blocklogic.agritechevolved.datagen.ATEItemTagProvider;
import com.blocklogic.agritechevolved.datagen.ATELootTableProvider;
import com.blocklogic.agritechevolved.datagen.ATERecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="agritechevolved", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ATELootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ATEItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ATEBlockStateProvider(packOutput, existingFileHelper));
        ATEBlockTagProvider blockTagsProvider = new ATEBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ATEItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ATERecipeProvider(packOutput, lookupProvider));
    }
}

