/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.config;

import com.blocklogic.agritechevolved.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.Item;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;

public class CompostableOverrideConfig {
    private static final Logger MAIN_LOGGER = LogUtils.getLogger();
    private static org.apache.logging.log4j.Logger ERROR_LOGGER = null;
    private static boolean HAS_LOGGED_ERRORS = false;
    private static Path ERROR_LOG_PATH = null;
    private static final String OVERRIDE_FILE_NAME = "compostable_config_overrides.toml";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\[(\\w+)\\]");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*(.+)");

    private static void setupErrorLogger() {
        ERROR_LOGGER = LogManager.getLogger(CompostableOverrideConfig.class);
    }

    private static synchronized void createLogFileIfNeeded() {
        if (HAS_LOGGED_ERRORS) {
            return;
        }
        try {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            String logFileName = "compostable_config_overrides_errors_" + timestamp + ".log";
            ERROR_LOG_PATH = FMLPaths.CONFIGDIR.get().resolve("agritechevolved/compostable_overrides").resolve("compostable_config_logs").resolve(logFileName);
            Files.createDirectories(ERROR_LOG_PATH.getParent(), new FileAttribute[0]);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{yyyy-MM-dd HH:mm:ss} [%p] %m%n").build();
            FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("CompostableOverrideErrorAppender")).withFileName(ERROR_LOG_PATH.toString()).setLayout((Layout)layout)).setConfiguration(config)).build();
            appender.start();
            config.addAppender((Appender)appender);
            LoggerConfig loggerConfig = new LoggerConfig("CompostableOverrideErrorLogger", Level.INFO, false);
            loggerConfig.addAppender((Appender)appender, Level.INFO, null);
            config.addLogger("CompostableOverrideErrorLogger", loggerConfig);
            context.updateLoggers();
            ERROR_LOGGER = LogManager.getLogger((String)"CompostableOverrideErrorLogger");
            MAIN_LOGGER.info("Created compostable override config error log file: {}", (Object)ERROR_LOG_PATH);
            HAS_LOGGED_ERRORS = true;
        }
        catch (Exception e) {
            MAIN_LOGGER.error("Failed to set up dedicated error logger: {}", (Object)e.getMessage());
        }
    }

    private static void logError(String message, Object ... params) {
        CompostableOverrideConfig.createLogFileIfNeeded();
        ERROR_LOGGER.error(message, params);
    }

    private static void logWarning(String message, Object ... params) {
        CompostableOverrideConfig.createLogFileIfNeeded();
        ERROR_LOGGER.warn(message, params);
    }

    public static void loadOverrides(Set<String> compostableItems) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("agritechevolved/compostable_overrides");
        Path overridePath = configDir.resolve(OVERRIDE_FILE_NAME);
        CompostableOverrideConfig.setupErrorLogger();
        if (!Files.exists(overridePath, new LinkOption[0])) {
            CompostableOverrideConfig.createDefaultOverrideFile(configDir, overridePath);
        }
        try {
            MAIN_LOGGER.info("Loading compostable overrides from {}", (Object)overridePath);
            Map<String, List<String>> sections = CompostableOverrideConfig.parseTomlFile(overridePath);
            int compostableCount = CompostableOverrideConfig.processCompostableEntries(sections.getOrDefault("compostable", Collections.emptyList()), compostableItems);
            MAIN_LOGGER.info("Successfully loaded {} compostable overrides", (Object)compostableCount);
        }
        catch (Exception e) {
            MAIN_LOGGER.error("Failed to load compostable override.toml file: {}", (Object)e.getMessage());
            CompostableOverrideConfig.logError("Failed to load compostable override.toml file: {}", e.getMessage());
            CompostableOverrideConfig.logError("The override file will be ignored, but the mod will continue to function", new Object[0]);
        }
    }

    private static Map<String, List<String>> parseTomlFile(Path filePath) throws IOException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        String currentSection = null;
        ArrayList<String> currentItems = null;
        try (BufferedReader reader = Files.newBufferedReader(filePath);){
            String line;
            while ((line = reader.readLine()) != null) {
                int commentPos = line.indexOf(35);
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).isEmpty()) continue;
                Matcher sectionMatcher = SECTION_PATTERN.matcher(line);
                if (sectionMatcher.matches()) {
                    currentSection = sectionMatcher.group(1);
                    currentItems = new ArrayList<String>();
                    result.put(currentSection, currentItems);
                    continue;
                }
                Matcher keyValueMatcher = KEY_VALUE_PATTERN.matcher(line);
                if (!keyValueMatcher.matches() || !"compostable".equals(currentSection)) continue;
                String value = keyValueMatcher.group(2);
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (currentItems == null) continue;
                currentItems.add(value);
            }
        }
        return result;
    }

    private static int processCompostableEntries(List<String> itemIds, Set<String> compostableItems) {
        int count = 0;
        for (String itemId : itemIds) {
            try {
                Item item = RegistryHelper.getItem(itemId);
                if (item == null) {
                    MAIN_LOGGER.warn("Compostable override uses non-existent item: {}", (Object)itemId);
                    CompostableOverrideConfig.logWarning("Compostable override uses non-existent item: {}", itemId);
                    continue;
                }
                compostableItems.add(itemId);
                ++count;
                MAIN_LOGGER.info("Added compostable override for item: {}", (Object)itemId);
            }
            catch (Exception e) {
                MAIN_LOGGER.error("Error processing compostable override for '{}': {}", (Object)itemId, (Object)e.getMessage());
                CompostableOverrideConfig.logError("Error processing compostable override for '{}': {}", itemId, e.getMessage());
            }
        }
        return count;
    }

    private static void createDefaultOverrideFile(Path configDir, Path overridePath) {
        block9: {
            try {
                if (!Files.exists(configDir, new LinkOption[0])) {
                    Files.createDirectories(configDir, new FileAttribute[0]);
                }
                try (FileWriter writer = new FileWriter(overridePath.toFile());){
                    writer.write(CompostableOverrideConfig.createBasicTemplate());
                }
                MAIN_LOGGER.info("Created default compostable override.toml file with examples at {}", (Object)overridePath);
            }
            catch (IOException e) {
                MAIN_LOGGER.error("Failed to create default compostable override.toml file: {}", (Object)e.getMessage());
                if (!HAS_LOGGED_ERRORS) break block9;
                ERROR_LOGGER.error("Failed to create default compostable override.toml file: {}", (Object)e.getMessage());
            }
        }
    }

    public static void resetErrorFlag() {
        HAS_LOGGED_ERRORS = false;
        ERROR_LOGGER = null;
        ERROR_LOG_PATH = null;
    }

    private static String createBasicTemplate() {
        return "# Compostable Items Override Configuration\n# This file allows you to add custom compostable items without modifying the core configuration.\n# Any entries here will be ADDED to the existing configurations.\n\n# How to use:\n# 1. Add items to the [compostable] section using the format: item_name = \"mod:item_id\"\n# 2. Save the file and restart your game\n\n# IMPORTANT: Make sure to verify the exact item IDs from your mods\n# Incorrect IDs will be skipped with a warning message in the log\n# The mod uses resource location format (e.g., \"minecraft:wheat\" not just \"wheat\")\n# The easiest way to check IDs is with F3+H enabled (shows tooltip IDs) or via JEI/REI\n\n# Example compostable items (organic materials for the Composter):\n[compostable]\n# clay = \"minecraft:clay\"\n# custom_crop = \"examplemod:corn\"\n# organic_waste = \"examplemod:organic_matter\"\n\n# Notes:\n# - All vanilla organic items are already included by default\n# - Major mod compatibility (Mystical Agriculture, Farmer's Delight, etc.) is automatic\n# - This file is only for adding items from mods that aren't automatically supported\n";
    }
}

