/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.compat.jei;

import com.blocklogic.agritechevolved.config.PlantablesConfig;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class PlanterRecipe
implements IRecipeCategoryExtension {
    private final Ingredient plantableIngredient;
    private final Ingredient soilIngredient;
    private final List<ItemStack> outputs;
    private final PlantableType type;

    public PlanterRecipe(Ingredient plantableIngredient, Ingredient soilIngredient, List<ItemStack> outputs, PlantableType type) {
        this.plantableIngredient = plantableIngredient;
        this.soilIngredient = soilIngredient;
        this.outputs = outputs;
        this.type = type;
    }

    public Ingredient getPlantableIngredient() {
        return this.plantableIngredient;
    }

    public Ingredient getSeedIngredient() {
        return this.plantableIngredient;
    }

    public Ingredient getSaplingIngredient() {
        return this.plantableIngredient;
    }

    public Ingredient getSoilIngredient() {
        return this.soilIngredient;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public PlantableType getType() {
        return this.type;
    }

    public static PlanterRecipe createCrop(String seedId, String soilId) {
        return PlanterRecipe.create(seedId, soilId, PlantableType.CROP);
    }

    public static PlanterRecipe createTree(String saplingId, String soilId) {
        return PlanterRecipe.create(saplingId, soilId, PlantableType.TREE);
    }

    private static PlanterRecipe create(String plantableId, String soilId, PlantableType type) {
        Item plantableItem = RegistryHelper.getItem(plantableId);
        if (plantableItem == null) {
            LogUtils.getLogger().error("Failed to create planter recipe: {} item not found for ID: {}", (Object)(type == PlantableType.CROP ? "Seed" : "Sapling"), (Object)plantableId);
            throw new IllegalArgumentException((type == PlantableType.CROP ? "Seed" : "Sapling") + " item not found for ID: " + plantableId);
        }
        Block soilBlock = RegistryHelper.getBlock(soilId);
        if (soilBlock == null) {
            LogUtils.getLogger().error("Failed to create planter recipe: Soil block not found for ID: {}", (Object)soilId);
            throw new IllegalArgumentException("Soil block not found for ID: " + soilId);
        }
        Ingredient plantableIngredient = Ingredient.of((ItemLike[])new ItemLike[]{plantableItem});
        Ingredient soilIngredient = Ingredient.of((ItemLike[])new ItemLike[]{soilBlock.asItem()});
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<PlantablesConfig.DropInfo> drops = type == PlantableType.CROP ? PlantablesConfig.getCropDrops(plantableId) : PlantablesConfig.getTreeDrops(plantableId);
        for (PlantablesConfig.DropInfo dropInfo : drops) {
            if (!(dropInfo.chance > 0.0f)) continue;
            Item dropItem = RegistryHelper.getItem(dropInfo.item);
            if (dropItem != null) {
                ItemStack outputStack = new ItemStack((ItemLike)dropItem, (dropInfo.minCount + dropInfo.maxCount) / 2);
                outputs.add(outputStack);
                continue;
            }
            LogUtils.getLogger().error("Drop item not found for ID: {} in recipe for {} {}", new Object[]{dropInfo.item, type == PlantableType.CROP ? "seed" : "sapling", plantableId});
            throw new IllegalArgumentException("Drop item not found for ID: " + dropInfo.item + " in recipe for " + (type == PlantableType.CROP ? "seed" : "sapling") + " " + plantableId);
        }
        return new PlanterRecipe(plantableIngredient, soilIngredient, outputs, type);
    }

    public static enum PlantableType {
        CROP,
        TREE;

    }
}

