/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.compat.jade;

import com.blocklogic.agritechevolved.block.entity.AdvancedPlanterBlockEntity;
import com.blocklogic.agritechevolved.block.entity.BasicPlanterBlockEntity;
import com.blocklogic.agritechevolved.config.PlantablesConfig;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum PlanterProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!data.contains("hasCrop") || !data.getBoolean("hasCrop")) {
            return;
        }
        String cropName = data.getString("cropName");
        int currentStage = data.getInt("currentStage");
        int maxStage = data.getInt("maxStage");
        float progressPercent = data.getFloat("progressPercent");
        String soilName = data.getString("soilName");
        float growthModifier = data.getFloat("growthModifier");
        boolean isAdvanced = data.getBoolean("isAdvanced");
        if (progressPercent >= 100.0f) {
            tooltip.add((Component)Component.translatable((String)"jade.agritechevolved.crop_ready", (Object[])new Object[]{cropName}).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
        } else {
            tooltip.add((Component)Component.translatable((String)"jade.agritechevolved.crop_progress", (Object[])new Object[]{cropName, currentStage, maxStage, Math.round(progressPercent)}).withStyle(ChatFormatting.DARK_GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"jade.agritechevolved.soil_info", (Object[])new Object[]{soilName, String.format("%.2fx", Float.valueOf(growthModifier))}).withStyle(ChatFormatting.GRAY));
        if (isAdvanced) {
            if (data.contains("energyStored") && data.contains("maxEnergy")) {
                int energyStored = data.getInt("energyStored");
                int maxEnergy = data.getInt("maxEnergy");
                float energyPercent = maxEnergy > 0 ? (float)energyStored / (float)maxEnergy * 100.0f : 0.0f;
                tooltip.add((Component)Component.translatable((String)"jade.agritechevolved.energy_info", (Object[])new Object[]{String.format("%,d", energyStored), String.format("%,d", maxEnergy), Math.round(energyPercent)}).withStyle(ChatFormatting.GOLD));
            }
            if (data.contains("hasModules") && data.getBoolean("hasModules")) {
                String moduleInfo = data.getString("moduleInfo");
                tooltip.add((Component)Component.translatable((String)"jade.agritechevolved.modules_installed", (Object[])new Object[]{moduleInfo}).withStyle(ChatFormatting.BLUE));
            }
            if (data.contains("hasFertilizer") && data.getBoolean("hasFertilizer")) {
                String fertilizerName = data.getString("fertilizerName");
                tooltip.add((Component)Component.translatable((String)"jade.agritechevolved.fertilizer_info", (Object[])new Object[]{fertilizerName}).withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof BasicPlanterBlockEntity) {
            BasicPlanterBlockEntity basicPlanter = (BasicPlanterBlockEntity)blockEntity;
            this.appendBasicPlanterData(data, basicPlanter);
        } else {
            blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof AdvancedPlanterBlockEntity) {
                AdvancedPlanterBlockEntity advancedPlanter = (AdvancedPlanterBlockEntity)blockEntity;
                this.appendAdvancedPlanterData(data, advancedPlanter);
            }
        }
    }

    private void appendBasicPlanterData(CompoundTag data, BasicPlanterBlockEntity planter) {
        ItemStack seedStack = planter.inventory.getStackInSlot(0);
        ItemStack soilStack = planter.inventory.getStackInSlot(1);
        data.putBoolean("isAdvanced", false);
        if (!seedStack.isEmpty() && !soilStack.isEmpty()) {
            data.putBoolean("hasCrop", true);
            data.putString("cropName", seedStack.getDisplayName().getString());
            data.putInt("currentStage", planter.getGrowthStage());
            data.putInt("maxStage", this.getMaxStage(seedStack));
            data.putFloat("progressPercent", planter.getGrowthProgress() * 100.0f);
            data.putString("soilName", soilStack.getDisplayName().getString());
            data.putFloat("growthModifier", planter.getSoilGrowthModifier(soilStack));
        } else {
            data.putBoolean("hasCrop", false);
        }
    }

    private void appendAdvancedPlanterData(CompoundTag data, AdvancedPlanterBlockEntity planter) {
        ItemStack seedStack = planter.inventory.getStackInSlot(0);
        ItemStack soilStack = planter.inventory.getStackInSlot(1);
        data.putBoolean("isAdvanced", true);
        if (!seedStack.isEmpty() && !soilStack.isEmpty()) {
            ItemStack fertilizerStack;
            data.putBoolean("hasCrop", true);
            data.putString("cropName", seedStack.getDisplayName().getString());
            data.putInt("currentStage", planter.getGrowthStage());
            data.putInt("maxStage", this.getMaxStage(seedStack));
            data.putFloat("progressPercent", planter.getGrowthProgress() * 100.0f);
            data.putString("soilName", soilStack.getDisplayName().getString());
            data.putFloat("growthModifier", planter.getSoilGrowthModifier(soilStack));
            StringBuilder moduleInfo = new StringBuilder();
            boolean hasModules = false;
            for (int slot = 2; slot <= 3; ++slot) {
                ItemStack moduleStack = planter.inventory.getStackInSlot(slot);
                if (moduleStack.isEmpty()) continue;
                if (hasModules) {
                    moduleInfo.append(", ");
                }
                moduleInfo.append(moduleStack.getDisplayName().getString());
                hasModules = true;
            }
            data.putBoolean("hasModules", hasModules);
            if (hasModules) {
                data.putString("moduleInfo", moduleInfo.toString());
            }
            if (!(fertilizerStack = planter.inventory.getStackInSlot(4)).isEmpty()) {
                data.putBoolean("hasFertilizer", true);
                data.putString("fertilizerName", fertilizerStack.getDisplayName().getString());
            } else {
                data.putBoolean("hasFertilizer", false);
            }
        } else {
            data.putBoolean("hasCrop", false);
        }
    }

    private int getMaxStage(ItemStack plantStack) {
        String itemId = RegistryHelper.getItemId(plantStack);
        if (PlantablesConfig.isValidSapling(itemId)) {
            return 1;
        }
        return 8;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    static {
        UID = ResourceLocation.fromNamespaceAndPath((String)"agritechevolved", (String)"planter_info");
    }
}

