/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.entity.renderer;

import com.blocklogic.agritechevolved.block.entity.AdvancedPlanterBlockEntity;
import com.blocklogic.agritechevolved.block.entity.BasicPlanterBlockEntity;
import com.blocklogic.agritechevolved.config.PlantablesConfig;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PlanterBlockEntityRenderer
implements BlockEntityRenderer<BlockEntity> {
    public PlanterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack plantStack;
        BlockState soilState;
        BlockItem blockItem;
        ItemStack soilStack;
        Item item;
        int growthStage;
        float growthProgress;
        ItemStackHandler inventory;
        if (blockEntity instanceof AdvancedPlanterBlockEntity) {
            AdvancedPlanterBlockEntity advancedPlanter = (AdvancedPlanterBlockEntity)blockEntity;
            inventory = advancedPlanter.inventory;
            growthProgress = advancedPlanter.getGrowthProgress();
            growthStage = advancedPlanter.getGrowthStage();
        } else if (blockEntity instanceof BasicPlanterBlockEntity) {
            BasicPlanterBlockEntity basicPlanter = (BasicPlanterBlockEntity)blockEntity;
            inventory = basicPlanter.inventory;
            growthProgress = basicPlanter.getGrowthProgress();
            growthStage = basicPlanter.getGrowthStage();
        } else {
            return;
        }
        if (!inventory.getStackInSlot(1).isEmpty() && (item = (soilStack = inventory.getStackInSlot(1)).getItem()) instanceof BlockItem) {
            blockItem = (BlockItem)item;
            soilState = blockItem.getBlock().defaultBlockState();
            poseStack.pushPose();
            poseStack.translate(0.175, 0.4, 0.175);
            poseStack.scale(0.65f, 0.05f, 0.65f);
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            dispatcher.renderSingleBlock(soilState, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        if (!inventory.getStackInSlot(0).isEmpty() && !inventory.getStackInSlot(1).isEmpty() && (soilState = (plantStack = inventory.getStackInSlot(0)).getItem()) instanceof BlockItem) {
            blockItem = (BlockItem)soilState;
            String plantId = RegistryHelper.getItemId(plantStack);
            boolean isTree = PlantablesConfig.isValidSapling(plantId);
            boolean isCrop = PlantablesConfig.isValidSeed(plantId);
            if (isTree || isCrop) {
                Block plantBlock = blockItem.getBlock();
                BlockState plantState = plantBlock.defaultBlockState();
                poseStack.pushPose();
                if (isTree) {
                    poseStack.translate(0.5, 0.45, 0.5);
                    float scale = 0.3f + growthProgress * 0.4f;
                    poseStack.scale(scale, scale, scale);
                    poseStack.translate(-0.5, 0.0, -0.5);
                } else {
                    poseStack.translate(0.1725, 0.45, 0.1725);
                    plantState = this.getCropBlockState(plantStack, growthStage);
                    float actualProgress = Math.min(1.0f, growthProgress);
                    float growthScale = 0.2f + actualProgress * 0.5f;
                    poseStack.scale(0.65f, growthScale, 0.65f);
                }
                BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                dispatcher.renderSingleBlock(plantState, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        }
    }

    private BlockState getCropBlockState(ItemStack stack, int age) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        BlockState defaultState = block.defaultBlockState();
        for (Property property : defaultState.getProperties()) {
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty intProperty = (IntegerProperty)property;
            if (!property.getName().equals("age")) continue;
            int maxAge = intProperty.getPossibleValues().stream().mapToInt(Integer::intValue).max().orElse(7);
            int clampedAge = Math.min(age, maxAge);
            return (BlockState)defaultState.setValue((Property)intProperty, (Comparable)Integer.valueOf(clampedAge));
        }
        if (defaultState.hasProperty((Property)BlockStateProperties.AGE_7)) {
            return (BlockState)defaultState.setValue((Property)BlockStateProperties.AGE_7, (Comparable)Integer.valueOf(Math.min(age, 7)));
        }
        if (defaultState.hasProperty((Property)BlockStateProperties.AGE_3)) {
            return (BlockState)defaultState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(Math.min(age, 3)));
        }
        if (defaultState.hasProperty((Property)BlockStateProperties.AGE_5)) {
            return (BlockState)defaultState.setValue((Property)BlockStateProperties.AGE_5, (Comparable)Integer.valueOf(Math.min(age, 5)));
        }
        if (defaultState.hasProperty((Property)BlockStateProperties.AGE_15)) {
            return (BlockState)defaultState.setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(Math.min(age, 15)));
        }
        if (defaultState.hasProperty((Property)BlockStateProperties.AGE_25)) {
            return (BlockState)defaultState.setValue((Property)BlockStateProperties.AGE_25, (Comparable)Integer.valueOf(Math.min(age, 25)));
        }
        return defaultState;
    }
}

