/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.entity;

import com.blocklogic.agritechevolved.Config;
import com.blocklogic.agritechevolved.block.custom.ComposterBlock;
import com.blocklogic.agritechevolved.block.entity.ATEBlockEntities;
import com.blocklogic.agritechevolved.config.CompostableConfig;
import com.blocklogic.agritechevolved.item.ATEItems;
import com.blocklogic.agritechevolved.screen.custom.ComposterMenu;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ComposterBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int INPUT_SLOTS_START = 0;
    private static final int INPUT_SLOTS_COUNT = 12;
    private static final int OUTPUT_SLOTS_START = 12;
    private static final int OUTPUT_SLOTS_COUNT = 3;
    private static final int MODULE_SLOT = 15;
    private int progress = 0;
    private int energyStored = 0;
    public final ItemStackHandler inventory = new ItemStackHandler(16){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 15) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot >= 0 && slot < 12) {
                return ComposterBlockEntity.this.isCompostable(stack);
            }
            if (slot >= 12 && slot < 15) {
                return false;
            }
            if (slot == 15) {
                return ComposterBlockEntity.this.isSpeedModule(stack);
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            ComposterBlockEntity.this.setChanged();
            if (ComposterBlockEntity.this.level != null && !ComposterBlockEntity.this.level.isClientSide()) {
                ComposterBlockEntity.this.level.sendBlockUpdated(ComposterBlockEntity.this.getBlockPos(), ComposterBlockEntity.this.getBlockState(), ComposterBlockEntity.this.getBlockState(), 3);
            }
        }
    };

    public ComposterBlockEntity(BlockPos pos, BlockState blockState) {
        super(ATEBlockEntities.COMPOSTER_BE.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ComposterBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        boolean wasChanged = false;
        int requiredEnergy = Config.getComposterBasePowerConsumption();
        boolean hasPower = blockEntity.energyStored >= requiredEnergy;
        int baseProcessingTime = Config.getComposterBaseProcessingTime();
        if (!hasPower) {
            baseProcessingTime *= 3;
        }
        double speedMultiplier = blockEntity.getModuleSpeedModifier();
        int actualProcessingTime = (int)Math.max(1.0, (double)baseProcessingTime / speedMultiplier);
        if (blockEntity.canProcess()) {
            if (blockEntity.progress == 0) {
                blockEntity.progress = 1;
                wasChanged = true;
            } else {
                ++blockEntity.progress;
                wasChanged = true;
            }
            if (blockEntity.progress >= actualProcessingTime) {
                blockEntity.processItems();
                if (hasPower) {
                    double powerMultiplier = blockEntity.getModulePowerModifier();
                    int adjustedEnergyConsumption = (int)Math.ceil((double)requiredEnergy * powerMultiplier);
                    blockEntity.energyStored -= adjustedEnergyConsumption;
                }
                blockEntity.progress = 0;
                wasChanged = true;
            }
        } else if (blockEntity.progress > 0) {
            blockEntity.progress = 0;
            wasChanged = true;
        }
        if (wasChanged) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
            boolean shouldBePowered = blockEntity.progress > 0;
            boolean currentlyPowered = (Boolean)state.getValue((Property)ComposterBlock.POWERED);
            if (shouldBePowered != currentlyPowered) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ComposterBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
            }
        }
    }

    private boolean canProcess() {
        int requiredItems;
        int availableOrganicItems = this.countAvailableOrganicItems();
        if (availableOrganicItems < (requiredItems = Config.getComposterItemsPerBiomass())) {
            return false;
        }
        return this.hasSpaceForBiomass();
    }

    private int countAvailableOrganicItems() {
        int count = 0;
        for (int i = 0; i < 12; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.isEmpty() || !this.isCompostable(stack)) continue;
            count += stack.getCount();
        }
        return count;
    }

    private boolean hasSpaceForBiomass() {
        ItemStack biomassStack = new ItemStack((ItemLike)ATEItems.BIOMASS.get());
        for (int i = 12; i < 15; ++i) {
            ItemStack outputStack = this.inventory.getStackInSlot(i);
            if (outputStack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)biomassStack) || outputStack.getCount() >= outputStack.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    private void processItems() {
        int requiredItems;
        int itemsToConsume = requiredItems = Config.getComposterItemsPerBiomass();
        for (int i = 0; i < 12 && itemsToConsume > 0; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.isEmpty() || !this.isCompostable(stack)) continue;
            int toTake = Math.min(itemsToConsume, stack.getCount());
            stack.shrink(toTake);
            itemsToConsume -= toTake;
            if (!stack.isEmpty()) continue;
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.addBiomassToOutput();
    }

    private void addBiomassToOutput() {
        ItemStack biomassStack = new ItemStack((ItemLike)ATEItems.BIOMASS.get(), 1);
        for (int i = 12; i < 15; ++i) {
            ItemStack outputStack = this.inventory.getStackInSlot(i);
            if (outputStack.isEmpty()) {
                this.inventory.setStackInSlot(i, biomassStack);
                return;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)biomassStack) || outputStack.getCount() >= outputStack.getMaxStackSize()) continue;
            outputStack.grow(1);
            return;
        }
    }

    private boolean isCompostable(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(stack);
        return CompostableConfig.isCompostable(itemId);
    }

    private boolean isSpeedModule(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(stack);
        return itemId.equals("agritechevolved:sm_mk1") || itemId.equals("agritechevolved:sm_mk2") || itemId.equals("agritechevolved:sm_mk3");
    }

    private double getModuleSpeedModifier() {
        String moduleId;
        ItemStack moduleStack = this.inventory.getStackInSlot(15);
        if (moduleStack.isEmpty()) {
            return 1.0;
        }
        return switch (moduleId = RegistryHelper.getItemId(moduleStack)) {
            case "agritechevolved:sm_mk1" -> Config.getSpeedModuleMk1Multiplier();
            case "agritechevolved:sm_mk2" -> Config.getSpeedModuleMk2Multiplier();
            case "agritechevolved:sm_mk3" -> Config.getSpeedModuleMk3Multiplier();
            default -> 1.0;
        };
    }

    private double getModulePowerModifier() {
        String moduleId;
        ItemStack moduleStack = this.inventory.getStackInSlot(15);
        if (moduleStack.isEmpty()) {
            return 1.0;
        }
        return switch (moduleId = RegistryHelper.getItemId(moduleStack)) {
            case "agritechevolved:sm_mk1" -> Config.getSpeedModuleMk1PowerMultiplier();
            case "agritechevolved:sm_mk2" -> Config.getSpeedModuleMk2PowerMultiplier();
            case "agritechevolved:sm_mk3" -> Config.getSpeedModuleMk3PowerMultiplier();
            default -> 1.0;
        };
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return Config.getComposterEnergyBuffer();
    }

    public boolean canExtractEnergy() {
        return false;
    }

    public boolean canReceiveEnergy() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(maxReceive, Config.getComposterEnergyBuffer() - this.energyStored);
        if (!simulate) {
            this.energyStored += energyReceived;
            this.setChanged();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return ComposterBlockEntity.this.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return ComposterBlockEntity.this.extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return ComposterBlockEntity.this.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return ComposterBlockEntity.this.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return ComposterBlockEntity.this.canExtractEnergy();
            }

            public boolean canReceive() {
                return ComposterBlockEntity.this.canReceiveEnergy();
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        return new IItemHandler(){

            public int getSlots() {
                return 16;
            }

            public ItemStack getStackInSlot(int slot) {
                return ComposterBlockEntity.this.inventory.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (slot >= 0 && slot < 12 || slot == 15) {
                    return ComposterBlockEntity.this.inventory.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot >= 12 && slot < 15) {
                    return ComposterBlockEntity.this.inventory.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return ComposterBlockEntity.this.inventory.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ComposterBlockEntity.this.inventory.isItemValid(slot, stack);
            }
        };
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        boolean hasPower;
        int baseProcessingTime = Config.getComposterBaseProcessingTime();
        int requiredEnergy = Config.getComposterBasePowerConsumption();
        boolean bl = hasPower = this.energyStored >= requiredEnergy;
        if (!hasPower) {
            baseProcessingTime *= 4;
        }
        double speedMultiplier = this.getModuleSpeedModifier();
        return (int)Math.max(1.0, (double)baseProcessingTime / speedMultiplier);
    }

    public int getOrganicItemsCollected() {
        return this.countAvailableOrganicItems();
    }

    public int getRequiredOrganicItems() {
        return Config.getComposterItemsPerBiomass();
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("progress", this.progress);
        tag.putInt("energyStored", this.energyStored);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("progress");
        this.energyStored = tag.getInt("energyStored");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.agritechevolved.composter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new ComposterMenu(containerId, playerInventory, this);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ATEBlockEntities.COMPOSTER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof ComposterBlockEntity) {
                ComposterBlockEntity composterBlockEntity = blockEntity;
                return composterBlockEntity.getItemHandler((Direction)direction);
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ATEBlockEntities.COMPOSTER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof ComposterBlockEntity) {
                ComposterBlockEntity composterBlockEntity = blockEntity;
                return composterBlockEntity.getEnergyStorage((Direction)direction);
            }
            return null;
        });
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }
}

