/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.entity;

import com.blocklogic.agritechevolved.Config;
import com.blocklogic.agritechevolved.block.custom.BiomassBurnerBlock;
import com.blocklogic.agritechevolved.block.entity.ATEBlockEntities;
import com.blocklogic.agritechevolved.screen.custom.BiomassBurnerMenu;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BiomassBurnerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            String itemId = RegistryHelper.getItemId(stack);
            return itemId.equals("agritechevolved:biomass") || itemId.equals("agritechevolved:crude_biomass") || itemId.equals("agritechevolved:compacted_biomass_block") || itemId.equals("agritechevolved:compacted_biomass");
        }

        protected void onContentsChanged(int slot) {
            BiomassBurnerBlockEntity.this.setChanged();
            if (!BiomassBurnerBlockEntity.this.level.isClientSide()) {
                BiomassBurnerBlockEntity.this.level.sendBlockUpdated(BiomassBurnerBlockEntity.this.getBlockPos(), BiomassBurnerBlockEntity.this.getBlockState(), BiomassBurnerBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final GeneratorEnergyStorage energyStorage = new GeneratorEnergyStorage(this, Config.getBurnerEnergyBuffer());
    private int progress = 0;
    private int maxProgress = 0;
    private int currentBurnValue = 0;
    private boolean isBurning = false;

    public BiomassBurnerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ATEBlockEntities.BURNER_BE.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BiomassBurnerBlockEntity blockEntity) {
        boolean currentlyBurning;
        boolean shouldBeBurning;
        boolean energyDistributed;
        if (level == null || level.isClientSide()) {
            return;
        }
        boolean wasChanged = false;
        if (!blockEntity.isBurning && blockEntity.canStartBurning()) {
            blockEntity.startBurning();
            wasChanged = true;
        }
        if (blockEntity.isBurning && blockEntity.energyStorage.getEnergyStored() < blockEntity.energyStorage.getMaxEnergyStored()) {
            int generated;
            ++blockEntity.progress;
            if (blockEntity.currentBurnValue > 0 && (generated = blockEntity.energyStorage.generateEnergy(blockEntity.currentBurnValue)) > 0) {
                wasChanged = true;
            }
            if (blockEntity.progress >= blockEntity.maxProgress) {
                blockEntity.completeBurning();
                wasChanged = true;
            }
        }
        if (energyDistributed = blockEntity.distributeEnergy()) {
            wasChanged = true;
        }
        if (wasChanged) {
            blockEntity.setChanged();
            if (!level.isClientSide()) {
                level.sendBlockUpdated(pos, state, state, 3);
            }
        }
        if ((shouldBeBurning = blockEntity.isBurning()) != (currentlyBurning = ((Boolean)state.getValue((Property)BiomassBurnerBlock.BURNING)).booleanValue())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BiomassBurnerBlock.BURNING, (Comparable)Boolean.valueOf(shouldBeBurning)), 3);
        }
    }

    private boolean canStartBurning() {
        ItemStack fuelStack = this.inventory.getStackInSlot(0);
        if (fuelStack.isEmpty()) {
            return false;
        }
        if (this.energyStorage.getEnergyStored() >= this.energyStorage.getMaxEnergyStored()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(fuelStack);
        return itemId.equals("agritechevolved:biomass") || itemId.equals("agritechevolved:compacted_biomass") || itemId.equals("agritechevolved:compacted_biomass_block") || itemId.equals("agritechevolved:crude_biomass");
    }

    private void startBurning() {
        ItemStack fuelStack = this.inventory.getStackInSlot(0);
        if (fuelStack.isEmpty()) {
            return;
        }
        String itemId = RegistryHelper.getItemId(fuelStack);
        int baseRF = 0;
        int burnDuration = 0;
        int baseDuration = 0;
        switch (itemId) {
            case "agritechevolved:biomass": {
                baseRF = Config.getBurnerBiomassRfValue();
                burnDuration = Config.getBurnerBiomassBurnDuration();
                baseDuration = 100;
                break;
            }
            case "agritechevolved:compacted_biomass": {
                baseRF = Config.getBurnerCompactedBiomassRfValue();
                burnDuration = Config.getBurnerCompactedBiomassBurnDuration();
                baseDuration = 180;
                break;
            }
            case "agritechevolved:compacted_biomass_block": {
                baseRF = Config.getBurnerCompactedBiomassBlockRfValue();
                burnDuration = Config.getBurnerCompactedBiomassBlockBurnDuration();
                baseDuration = 180;
                break;
            }
            case "agritechevolved:crude_biomass": {
                baseRF = Config.getBurnerCrudeBiomassRfValue();
                burnDuration = Config.getBurnerCrudeBiomassBurnDuration();
                baseDuration = 50;
                break;
            }
            default: {
                return;
            }
        }
        int totalRF = (int)((float)baseRF * ((float)burnDuration / (float)baseDuration));
        if (totalRF <= 0 || burnDuration <= 0) {
            return;
        }
        this.maxProgress = burnDuration;
        this.currentBurnValue = totalRF / this.maxProgress;
        fuelStack.shrink(1);
        this.inventory.setStackInSlot(0, fuelStack);
        this.progress = 0;
        this.isBurning = true;
    }

    private void completeBurning() {
        this.progress = 0;
        this.maxProgress = 0;
        this.currentBurnValue = 0;
        this.isBurning = false;
    }

    private boolean distributeEnergy() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        boolean energyDistributed = false;
        for (Direction direction : Direction.values()) {
            int transferred;
            int energyToTransfer;
            IEnergyStorage neighborEnergy;
            BlockPos neighborPos = this.worldPosition.relative(direction);
            BlockEntity neighborBE = this.level.getBlockEntity(neighborPos);
            if (neighborBE == null || (neighborEnergy = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite())) == null || !neighborEnergy.canReceive() || (energyToTransfer = this.energyStorage.extractEnergy(1000, true)) <= 0 || (transferred = neighborEnergy.receiveEnergy(energyToTransfer, false)) <= 0) continue;
            this.energyStorage.extractEnergy(transferred, false);
            energyDistributed = true;
        }
        return energyDistributed;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.put("energy", this.energyStorage.serializeNBT(registries));
        tag.putInt("progress", this.progress);
        tag.putInt("maxProgress", this.maxProgress);
        tag.putInt("currentBurnValue", this.currentBurnValue);
        tag.putBoolean("isBurning", this.isBurning);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inventory")) {
            this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        }
        if (tag.contains("energy")) {
            this.energyStorage.deserializeNBT(registries, tag.get("energy"));
        }
        this.progress = tag.getInt("progress");
        this.maxProgress = tag.getInt("maxProgress");
        this.currentBurnValue = tag.getInt("currentBurnValue");
        this.isBurning = tag.getBoolean("isBurning");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canExtractEnergy() {
        return true;
    }

    public boolean canReceiveEnergy() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return BiomassBurnerBlockEntity.this.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return BiomassBurnerBlockEntity.this.extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return BiomassBurnerBlockEntity.this.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return BiomassBurnerBlockEntity.this.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return BiomassBurnerBlockEntity.this.canExtractEnergy();
            }

            public boolean canReceive() {
                return BiomassBurnerBlockEntity.this.canReceiveEnergy();
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        return new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            public ItemStack getStackInSlot(int slot) {
                return BiomassBurnerBlockEntity.this.inventory.getStackInSlot(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (stack.isEmpty()) {
                    return stack;
                }
                String itemId = RegistryHelper.getItemId(stack);
                if (itemId.equals("agritechevolved:biomass") || itemId.equals("agritechevolved:compacted_biomass")) {
                    return BiomassBurnerBlockEntity.this.inventory.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return BiomassBurnerBlockEntity.this.inventory.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return BiomassBurnerBlockEntity.this.inventory.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (stack.isEmpty()) {
                    return false;
                }
                String itemId = RegistryHelper.getItemId(stack);
                return itemId.equals("agritechevolved:biomass") || itemId.equals("agritechevolved:compacted_biomass") || itemId.equals("agritechevolved:crude_biomass");
            }
        };
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ATEBlockEntities.BURNER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof BiomassBurnerBlockEntity) {
                BiomassBurnerBlockEntity burnerBlockEntity = blockEntity;
                return burnerBlockEntity.getItemHandler((Direction)direction);
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ATEBlockEntities.BURNER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof BiomassBurnerBlockEntity) {
                BiomassBurnerBlockEntity burnerBlockEntity = blockEntity;
                return burnerBlockEntity.getEnergyStorage((Direction)direction);
            }
            return null;
        });
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.agritechevolved.biomass_burner");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new BiomassBurnerMenu(containerId, playerInventory, this);
    }

    private class GeneratorEnergyStorage
    extends EnergyStorage {
        public GeneratorEnergyStorage(BiomassBurnerBlockEntity biomassBurnerBlockEntity, int capacity) {
            super(capacity, 0, Integer.MAX_VALUE);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public boolean canReceive() {
            return false;
        }

        public boolean canExtract() {
            return true;
        }

        public int generateEnergy(int amount) {
            int availableSpace = this.capacity - this.energy;
            int generated = Math.min(amount, availableSpace);
            this.energy += generated;
            return generated;
        }
    }
}

