/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.entity;

import com.blocklogic.agritechevolved.Config;
import com.blocklogic.agritechevolved.block.ATEBlocks;
import com.blocklogic.agritechevolved.block.entity.ATEBlockEntities;
import com.blocklogic.agritechevolved.config.PlantablesConfig;
import com.blocklogic.agritechevolved.screen.custom.BasicPlanterMenu;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicPlanterBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(14){

        public int getSlotLimit(int slot) {
            if (slot == 0 || slot == 1) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            String itemId = RegistryHelper.getItemId(stack);
            switch (slot) {
                case 0: {
                    return PlantablesConfig.isValidSeed(itemId) || PlantablesConfig.isValidSapling(itemId);
                }
                case 1: {
                    return PlantablesConfig.isValidSoil(itemId);
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            BasicPlanterBlockEntity.this.setChanged();
            if (!BasicPlanterBlockEntity.this.level.isClientSide()) {
                BasicPlanterBlockEntity.this.level.sendBlockUpdated(BasicPlanterBlockEntity.this.getBlockPos(), BasicPlanterBlockEntity.this.getBlockState(), BasicPlanterBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private int growthProgress = 0;
    private int growthTicks = 0;
    private boolean readyToHarvest = false;
    private int lastGrowthStage = -1;

    public BasicPlanterBlockEntity(BlockPos pos, BlockState blockState) {
        super(ATEBlockEntities.BASIC_PLANTER_BE.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BasicPlanterBlockEntity blockEntity) {
        String soilId;
        if (level.isClientSide()) {
            return;
        }
        ItemStack plantStack = blockEntity.inventory.getStackInSlot(0);
        ItemStack soilStack = blockEntity.inventory.getStackInSlot(1);
        if (plantStack.isEmpty() || soilStack.isEmpty()) {
            blockEntity.resetGrowth();
            return;
        }
        String plantId = RegistryHelper.getItemId(plantStack);
        if (!blockEntity.isValidPlantSoilCombination(plantId, soilId = RegistryHelper.getItemId(soilStack))) {
            blockEntity.resetGrowth();
            return;
        }
        if (!blockEntity.readyToHarvest) {
            float soilModifier = blockEntity.getSoilGrowthModifier(soilStack);
            int baseGrowthTime = blockEntity.getBaseGrowthTime(plantStack);
            int adjustedGrowthTime = Math.max(1, Math.round((float)baseGrowthTime / soilModifier));
            ++blockEntity.growthTicks;
            if (blockEntity.growthTicks >= adjustedGrowthTime) {
                blockEntity.readyToHarvest = true;
                blockEntity.growthProgress = 100;
                blockEntity.lastGrowthStage = blockEntity.getGrowthStage();
                level.sendBlockUpdated(pos, state, state, 3);
                blockEntity.setChanged();
            } else {
                blockEntity.growthProgress = (int)((float)blockEntity.growthTicks / (float)adjustedGrowthTime * 100.0f);
                int currentGrowthStage = blockEntity.getGrowthStage();
                if (currentGrowthStage != blockEntity.lastGrowthStage) {
                    blockEntity.lastGrowthStage = currentGrowthStage;
                }
                if (blockEntity.growthTicks % 20 == 0) {
                    level.sendBlockUpdated(pos, state, state, 3);
                    blockEntity.setChanged();
                }
            }
        }
        if (blockEntity.readyToHarvest && blockEntity.hasOutputSpace()) {
            blockEntity.harvestPlant();
        }
        if (state.is((Block)ATEBlocks.BASIC_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_ACACIA_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_BAMBOO_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_BIRCH_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_CHERRY_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_CRIMSON_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_DARK_OAK_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_JUNGLE_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_MANGROVE_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_SPRUCE_PLANTER.get()) || state.is((Block)ATEBlocks.BASIC_WARPED_PLANTER.get())) {
            BasicPlanterBlockEntity.tryOutputItemsBelow(level, pos, blockEntity);
        }
    }

    private boolean isValidPlantSoilCombination(String plantId, String soilId) {
        if (PlantablesConfig.isValidSeed(plantId)) {
            return PlantablesConfig.isSoilValidForSeed(soilId, plantId);
        }
        if (PlantablesConfig.isValidSapling(plantId)) {
            return PlantablesConfig.isSoilValidForSapling(soilId, plantId);
        }
        return false;
    }

    private boolean isTree() {
        ItemStack plantStack = this.inventory.getStackInSlot(0);
        if (plantStack.isEmpty()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(plantStack);
        return PlantablesConfig.isValidSapling(itemId);
    }

    private boolean isCrop() {
        ItemStack plantStack = this.inventory.getStackInSlot(0);
        if (plantStack.isEmpty()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(plantStack);
        return PlantablesConfig.isValidSeed(itemId);
    }

    private int getBaseGrowthTime(ItemStack plantStack) {
        String itemId = RegistryHelper.getItemId(plantStack);
        if (PlantablesConfig.isValidSeed(itemId)) {
            return Config.getPlanterBaseProcessingTime();
        }
        if (PlantablesConfig.isValidSapling(itemId)) {
            return PlantablesConfig.getBaseSaplingGrowthTime(itemId);
        }
        return Config.getPlanterBaseProcessingTime();
    }

    public float getSoilGrowthModifier(ItemStack soilStack) {
        if (soilStack.isEmpty()) {
            return 1.0f;
        }
        String soilId = RegistryHelper.getItemId(soilStack);
        return PlantablesConfig.getSoilGrowthModifier(soilId);
    }

    private void resetGrowth() {
        this.growthProgress = 0;
        this.growthTicks = 0;
        this.readyToHarvest = false;
        this.lastGrowthStage = -1;
        this.setChanged();
    }

    public void harvestPlant() {
        if (!this.readyToHarvest) {
            return;
        }
        ItemStack plantStack = this.inventory.getStackInSlot(0);
        List<ItemStack> drops = this.getHarvestDrops(plantStack);
        for (ItemStack drop : drops) {
            int remainingItemsToPlace = drop.getCount();
            for (int slot = 2; slot <= 13; ++slot) {
                ItemStack existingStack = this.inventory.getStackInSlot(slot);
                if (existingStack.isEmpty()) {
                    int itemsToPlace = Math.min(remainingItemsToPlace, drop.getMaxStackSize());
                    this.inventory.setStackInSlot(slot, new ItemStack((ItemLike)drop.getItem(), itemsToPlace));
                    remainingItemsToPlace -= itemsToPlace;
                } else if (existingStack.is(drop.getItem()) && existingStack.getCount() < existingStack.getMaxStackSize()) {
                    int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
                    int itemsToAdd = Math.min(spaceAvailable, remainingItemsToPlace);
                    existingStack.grow(itemsToAdd);
                    remainingItemsToPlace -= itemsToAdd;
                }
                if (remainingItemsToPlace <= 0) break;
            }
            if (remainingItemsToPlace <= 0) continue;
            break;
        }
        this.resetGrowth();
    }

    private List<ItemStack> getHarvestDrops(ItemStack plantStack) {
        List<PlantablesConfig.DropInfo> configDrops;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = new Random();
        if (plantStack.isEmpty()) {
            return drops;
        }
        String plantId = RegistryHelper.getItemId(plantStack);
        if (PlantablesConfig.isValidSeed(plantId)) {
            configDrops = PlantablesConfig.getCropDrops(plantId);
        } else if (PlantablesConfig.isValidSapling(plantId)) {
            configDrops = PlantablesConfig.getTreeDrops(plantId);
        } else {
            return drops;
        }
        for (PlantablesConfig.DropInfo dropInfo : configDrops) {
            Item item;
            if (!(random.nextFloat() <= dropInfo.chance)) continue;
            int count = dropInfo.minCount;
            if (dropInfo.maxCount > dropInfo.minCount) {
                count = dropInfo.minCount + random.nextInt(dropInfo.maxCount - dropInfo.minCount + 1);
            }
            if ((item = RegistryHelper.getItem(dropInfo.item)) == null) continue;
            drops.add(new ItemStack((ItemLike)item, count));
        }
        return drops;
    }

    private static void tryOutputItemsBelow(Level level, BlockPos pos, BasicPlanterBlockEntity blockEntity) {
        BlockPos belowPos = pos.below();
        BlockEntity targetEntity = level.getBlockEntity(belowPos);
        if (targetEntity == null) {
            return;
        }
        IItemHandler targetInventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, belowPos, (Object)Direction.UP);
        if (targetInventory == null) {
            return;
        }
        boolean changed = false;
        for (int slot = 2; slot <= 13; ++slot) {
            ItemStack extractedItem;
            if (blockEntity.inventory.getStackInSlot(slot).isEmpty() || (extractedItem = blockEntity.inventory.extractItem(slot, 64, true)).isEmpty()) continue;
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedItem, (boolean)false);
            int insertedAmount = extractedItem.getCount() - remaining.getCount();
            if (insertedAmount <= 0) continue;
            blockEntity.inventory.extractItem(slot, insertedAmount, false);
            changed = true;
        }
        if (changed) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
        }
    }

    public boolean hasOutputSpace() {
        List<ItemStack> potentialDrops = this.getHarvestDrops(this.inventory.getStackInSlot(0));
        HashMap<Integer, ItemStack> simulatedSlots = new HashMap<Integer, ItemStack>();
        for (int slot = 2; slot <= 13; ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            simulatedSlots.put(slot, stack.isEmpty() ? ItemStack.EMPTY : stack.copy());
        }
        for (ItemStack drop : potentialDrops) {
            ItemStack existingStack;
            int slot;
            int remainingToPlace = drop.getCount();
            for (slot = 2; slot <= 13; ++slot) {
                existingStack = (ItemStack)simulatedSlots.get(slot);
                if (existingStack.isEmpty() || !existingStack.is(drop.getItem()) || existingStack.getCount() >= existingStack.getMaxStackSize()) continue;
                int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
                int itemsToAdd = Math.min(spaceAvailable, remainingToPlace);
                existingStack.grow(itemsToAdd);
                if ((remainingToPlace -= itemsToAdd) <= 0) break;
            }
            if (remainingToPlace > 0) {
                for (slot = 2; slot <= 13; ++slot) {
                    existingStack = (ItemStack)simulatedSlots.get(slot);
                    if (!existingStack.isEmpty()) continue;
                    simulatedSlots.put(slot, new ItemStack((ItemLike)drop.getItem(), remainingToPlace));
                    remainingToPlace = 0;
                    break;
                }
            }
            if (remainingToPlace <= 0) continue;
            return false;
        }
        return true;
    }

    public float getGrowthProgress() {
        return (float)this.growthProgress / 100.0f;
    }

    public int getGrowthStage() {
        if (this.isTree()) {
            return this.growthProgress > 50 ? 1 : 0;
        }
        return Math.min(8, (int)((float)this.growthProgress / 12.5f));
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("growthProgress", this.growthProgress);
        tag.putInt("growthTicks", this.growthTicks);
        tag.putBoolean("readyToHarvest", this.readyToHarvest);
        tag.putInt("lastGrowthStage", this.lastGrowthStage);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.growthProgress = tag.getInt("growthProgress");
        this.growthTicks = tag.getInt("growthTicks");
        this.readyToHarvest = tag.getBoolean("readyToHarvest");
        this.lastGrowthStage = tag.getInt("lastGrowthStage");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.agritechevolved.basic_planter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new BasicPlanterMenu(i, inventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

