/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.entity;

import com.blocklogic.agritechevolved.Config;
import com.blocklogic.agritechevolved.block.custom.AdvancedPlanterBlock;
import com.blocklogic.agritechevolved.block.entity.ATEBlockEntities;
import com.blocklogic.agritechevolved.config.PlantablesConfig;
import com.blocklogic.agritechevolved.screen.custom.AdvancedPlanterMenu;
import com.blocklogic.agritechevolved.util.ATETags;
import com.blocklogic.agritechevolved.util.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedPlanterBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(17){

        public int getSlotLimit(int slot) {
            if (slot == 0 || slot == 1 || slot == 2 || slot == 3) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 4) {
                return 64;
            }
            return super.getStackLimit(slot, stack);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            String itemId = RegistryHelper.getItemId(stack);
            switch (slot) {
                case 0: {
                    if (!PlantablesConfig.isValidSeed(itemId) && !PlantablesConfig.isValidSapling(itemId)) {
                        return false;
                    }
                    ItemStack existingSoil = this.getStackInSlot(1);
                    if (!existingSoil.isEmpty()) {
                        String soilId = RegistryHelper.getItemId(existingSoil);
                        if (PlantablesConfig.isValidSeed(itemId)) {
                            return PlantablesConfig.isSoilValidForSeed(soilId, itemId);
                        }
                        if (PlantablesConfig.isValidSapling(itemId)) {
                            return PlantablesConfig.isSoilValidForSapling(soilId, itemId);
                        }
                    }
                    return true;
                }
                case 1: {
                    if (!PlantablesConfig.isValidSoil(itemId)) {
                        return false;
                    }
                    ItemStack existingPlant = this.getStackInSlot(0);
                    if (!existingPlant.isEmpty()) {
                        String plantId = RegistryHelper.getItemId(existingPlant);
                        if (PlantablesConfig.isValidSeed(plantId)) {
                            return PlantablesConfig.isSoilValidForSeed(itemId, plantId);
                        }
                        if (PlantablesConfig.isValidSapling(plantId)) {
                            return PlantablesConfig.isSoilValidForSapling(itemId, plantId);
                        }
                    }
                    return true;
                }
                case 2: 
                case 3: {
                    return stack.is(ATETags.Items.ATE_MODULES);
                }
                case 4: {
                    return PlantablesConfig.isValidFertilizer(itemId);
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    return false;
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            AdvancedPlanterBlockEntity.this.setChanged();
            if (!AdvancedPlanterBlockEntity.this.level.isClientSide()) {
                AdvancedPlanterBlockEntity.this.level.sendBlockUpdated(AdvancedPlanterBlockEntity.this.getBlockPos(), AdvancedPlanterBlockEntity.this.getBlockState(), AdvancedPlanterBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final OutputOnlyItemHandler outputHandler = new OutputOnlyItemHandler(this, this.inventory, 5, 16);
    private int growthProgress = 0;
    private int growthTicks = 0;
    private boolean readyToHarvest = false;
    private int energyStored = 0;
    private int lastGrowthStage = -1;
    private float currentTotalModifier = 1.0f;

    public IItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public AdvancedPlanterBlockEntity(BlockPos pos, BlockState blockState) {
        super(ATEBlockEntities.ADVANCED_PLANTER_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.agritechevolved.advanced_planter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new AdvancedPlanterMenu(i, inventory, this);
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return Config.getPlanterEnergyBuffer();
    }

    public boolean canExtractEnergy() {
        return false;
    }

    public boolean canReceiveEnergy() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(maxReceive, Config.getPlanterEnergyBuffer() - this.energyStored);
        if (!simulate) {
            this.energyStored += energyReceived;
            this.setChanged();
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    private boolean consumeEnergy() {
        float powerModifier = this.getModulePowerModifier();
        int powerRequired = Math.round((float)Config.getPlanterBasePowerConsumption() * powerModifier);
        if (this.energyStored >= powerRequired) {
            this.energyStored -= powerRequired;
            this.setChanged();
            return true;
        }
        return false;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return AdvancedPlanterBlockEntity.this.receiveEnergy(maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return AdvancedPlanterBlockEntity.this.extractEnergy(maxExtract, simulate);
            }

            public int getEnergyStored() {
                return AdvancedPlanterBlockEntity.this.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return AdvancedPlanterBlockEntity.this.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return AdvancedPlanterBlockEntity.this.canExtractEnergy();
            }

            public boolean canReceive() {
                return AdvancedPlanterBlockEntity.this.canReceiveEnergy();
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side == Direction.DOWN) {
            return this.outputHandler;
        }
        return new IItemHandler(){

            public int getSlots() {
                return 12;
            }

            public ItemStack getStackInSlot(int slot) {
                if (slot == 0) {
                    return AdvancedPlanterBlockEntity.this.inventory.getStackInSlot(4);
                }
                return AdvancedPlanterBlockEntity.this.inventory.getStackInSlot(slot + 4);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    return AdvancedPlanterBlockEntity.this.inventory.insertItem(4, stack, simulate);
                }
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 0) {
                    return ItemStack.EMPTY;
                }
                return AdvancedPlanterBlockEntity.this.inventory.extractItem(slot + 4, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return AdvancedPlanterBlockEntity.this.inventory.getSlotLimit(4);
                }
                return AdvancedPlanterBlockEntity.this.inventory.getSlotLimit(slot + 4);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 0) {
                    return AdvancedPlanterBlockEntity.this.inventory.isItemValid(4, stack);
                }
                return false;
            }
        };
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ATEBlockEntities.ADVANCED_PLANTER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof AdvancedPlanterBlockEntity) {
                AdvancedPlanterBlockEntity planterBlockEntity = blockEntity;
                return planterBlockEntity.getItemHandler((Direction)direction);
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, ATEBlockEntities.ADVANCED_PLANTER_BE.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof AdvancedPlanterBlockEntity) {
                AdvancedPlanterBlockEntity planterBlockEntity = blockEntity;
                return planterBlockEntity.getEnergyStorage((Direction)direction);
            }
            return null;
        });
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    private float getModuleSpeedModifier() {
        float speedModifier = 1.0f;
        float speedReduction = 1.0f;
        block16: for (int slot = 2; slot <= 3; ++slot) {
            String moduleId;
            ItemStack moduleStack = this.inventory.getStackInSlot(slot);
            if (moduleStack.isEmpty()) continue;
            switch (moduleId = RegistryHelper.getItemId(moduleStack)) {
                case "agritechevolved:sm_mk1": {
                    speedModifier = (float)((double)speedModifier * Config.getSpeedModuleMk1Multiplier());
                    continue block16;
                }
                case "agritechevolved:sm_mk2": {
                    speedModifier = (float)((double)speedModifier * Config.getSpeedModuleMk2Multiplier());
                    continue block16;
                }
                case "agritechevolved:sm_mk3": {
                    speedModifier = (float)((double)speedModifier * Config.getSpeedModuleMk3Multiplier());
                    continue block16;
                }
                case "agritechevolved:ym_mk1": {
                    speedReduction = (float)((double)speedReduction * Config.getYieldModuleMk1SpeedPenalty());
                    continue block16;
                }
                case "agritechevolved:ym_mk2": {
                    speedReduction = (float)((double)speedReduction * Config.getYieldModuleMk2SpeedPenalty());
                    continue block16;
                }
                case "agritechevolved:ym_mk3": {
                    speedReduction = (float)((double)speedReduction * Config.getYieldModuleMk3SpeedPenalty());
                }
            }
        }
        return speedModifier * speedReduction;
    }

    private float getModuleYieldModifier() {
        float yieldModifier = 1.0f;
        block10: for (int slot = 2; slot <= 3; ++slot) {
            String moduleId;
            ItemStack moduleStack = this.inventory.getStackInSlot(slot);
            if (moduleStack.isEmpty()) continue;
            switch (moduleId = RegistryHelper.getItemId(moduleStack)) {
                case "agritechevolved:ym_mk1": {
                    yieldModifier = (float)((double)yieldModifier * Config.getYieldModuleMk1Multiplier());
                    continue block10;
                }
                case "agritechevolved:ym_mk2": {
                    yieldModifier = (float)((double)yieldModifier * Config.getYieldModuleMk2Multiplier());
                    continue block10;
                }
                case "agritechevolved:ym_mk3": {
                    yieldModifier = (float)((double)yieldModifier * Config.getYieldModuleMk3Multiplier());
                }
            }
        }
        return yieldModifier;
    }

    private float getModulePowerModifier() {
        float powerModifier = 1.0f;
        block10: for (int slot = 2; slot <= 3; ++slot) {
            String moduleId;
            ItemStack moduleStack = this.inventory.getStackInSlot(slot);
            if (moduleStack.isEmpty()) continue;
            switch (moduleId = RegistryHelper.getItemId(moduleStack)) {
                case "agritechevolved:sm_mk1": {
                    powerModifier = (float)((double)powerModifier * Config.getSpeedModuleMk1PowerMultiplier());
                    continue block10;
                }
                case "agritechevolved:sm_mk2": {
                    powerModifier = (float)((double)powerModifier * Config.getSpeedModuleMk2PowerMultiplier());
                    continue block10;
                }
                case "agritechevolved:sm_mk3": {
                    powerModifier = (float)((double)powerModifier * Config.getSpeedModuleMk3PowerMultiplier());
                }
            }
        }
        return powerModifier;
    }

    private float getModuleGrowthModifier() {
        return this.getModuleSpeedModifier();
    }

    private float getFertilizerGrowthModifier() {
        String fertilizerId;
        ItemStack fertilizerStack = this.inventory.getStackInSlot(4);
        if (fertilizerStack.isEmpty()) {
            return 1.0f;
        }
        switch (fertilizerId = RegistryHelper.getItemId(fertilizerStack)) {
            case "agritechevolved:biomass": {
                return (float)Config.getFertilizerBiomassSpeedMultiplier();
            }
            case "agritechevolved:compacted_biomass": {
                return (float)Config.getFertilizerCompactedBiomassSpeedMultiplier();
            }
            case "minecraft:bone_meal": {
                return (float)Config.getFertilizerBoneMealSpeedMultiplier();
            }
            case "immersiveengineering:fertilizer": {
                return (float)Config.getFertilizerImmersiveFertilizerSpeedMultiplier();
            }
            case "mysticalagriculture:fertilized_essence": {
                return (float)Config.getFertilizerFertilizedEssenceSpeedMultiplier();
            }
            case "mysticalagriculture:mystical_fertilizer": {
                return (float)Config.getFertilizerMysticalFertilizerSpeedMultiplier();
            }
            case "forbidden_arcanus:arcane_bone_meal": {
                return (float)Config.getFertilizerArcaneBoneMealSpeedMultiplier();
            }
        }
        PlantablesConfig.FertilizerInfo fertilizerInfo = PlantablesConfig.getFertilizerInfo(fertilizerId);
        return fertilizerInfo != null ? fertilizerInfo.speedMultiplier : 1.0f;
    }

    private float getFertilizerYieldModifier() {
        String fertilizerId;
        ItemStack fertilizerStack = this.inventory.getStackInSlot(4);
        if (fertilizerStack.isEmpty()) {
            return 1.0f;
        }
        switch (fertilizerId = RegistryHelper.getItemId(fertilizerStack)) {
            case "agritechevolved:biomass": {
                return (float)Config.getFertilizerBiomassYieldMultiplier();
            }
            case "agritechevolved:compacted_biomass": {
                return (float)Config.getFertilizerCompactedBiomassYieldMultiplier();
            }
            case "minecraft:bone_meal": {
                return (float)Config.getFertilizerBoneMealYieldMultiplier();
            }
            case "immersiveengineering:fertilizer": {
                return (float)Config.getFertilizerImmersiveFertilizerYieldMultiplier();
            }
            case "mysticalagriculture:fertilized_essence": {
                return (float)Config.getFertilizerFertilizedEssenceYieldMultiplier();
            }
            case "mysticalagriculture:mystical_fertilizer": {
                return (float)Config.getFertilizerMysticalFertilizerYieldMultiplier();
            }
            case "forbidden_arcanus:arcane_bone_meal": {
                return (float)Config.getFertilizerArcaneBoneMealYieldMultiplier();
            }
        }
        PlantablesConfig.FertilizerInfo fertilizerInfo = PlantablesConfig.getFertilizerInfo(fertilizerId);
        return fertilizerInfo != null ? fertilizerInfo.yieldMultiplier : 1.0f;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AdvancedPlanterBlockEntity blockEntity) {
        String soilId;
        boolean powered;
        if (level.isClientSide()) {
            return;
        }
        boolean bl = powered = blockEntity.getEnergyStored() > 0;
        if ((Boolean)state.getValue((Property)AdvancedPlanterBlock.POWERED) != powered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AdvancedPlanterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        ItemStack plantStack = blockEntity.inventory.getStackInSlot(0);
        ItemStack soilStack = blockEntity.inventory.getStackInSlot(1);
        if (plantStack.isEmpty() || soilStack.isEmpty()) {
            blockEntity.resetGrowth();
            return;
        }
        String plantId = RegistryHelper.getItemId(plantStack);
        if (!blockEntity.isValidPlantSoilCombination(plantId, soilId = RegistryHelper.getItemId(soilStack))) {
            blockEntity.resetGrowth();
            return;
        }
        if (!blockEntity.readyToHarvest) {
            float totalModifier;
            if (!blockEntity.consumeEnergy()) {
                return;
            }
            float soilModifier = blockEntity.getSoilGrowthModifier(soilStack);
            float moduleModifier = blockEntity.getModuleGrowthModifier();
            float fertilizerGrowthModifier = blockEntity.getFertilizerGrowthModifier();
            blockEntity.currentTotalModifier = totalModifier = soilModifier * moduleModifier * fertilizerGrowthModifier;
            int baseGrowthTime = blockEntity.getBaseGrowthTime(plantStack);
            int adjustedGrowthTime = Math.max(1, Math.round((float)baseGrowthTime / totalModifier));
            ++blockEntity.growthTicks;
            if (blockEntity.growthTicks >= adjustedGrowthTime) {
                blockEntity.readyToHarvest = true;
                blockEntity.growthProgress = 100;
                blockEntity.lastGrowthStage = blockEntity.getGrowthStage();
                level.sendBlockUpdated(pos, state, state, 3);
                blockEntity.setChanged();
            } else {
                blockEntity.growthProgress = (int)((float)blockEntity.growthTicks / (float)adjustedGrowthTime * 100.0f);
                int currentGrowthStage = blockEntity.getGrowthStage();
                if (currentGrowthStage != blockEntity.lastGrowthStage) {
                    blockEntity.lastGrowthStage = currentGrowthStage;
                }
                if (blockEntity.growthTicks % 20 == 0) {
                    level.sendBlockUpdated(pos, state, state, 3);
                    blockEntity.setChanged();
                }
            }
        }
        if (blockEntity.readyToHarvest && blockEntity.hasOutputSpace()) {
            blockEntity.harvestPlant();
        }
        AdvancedPlanterBlockEntity.tryOutputItemsBelow(level, pos, blockEntity);
    }

    private boolean isValidPlantSoilCombination(String plantId, String soilId) {
        if (PlantablesConfig.isValidSeed(plantId)) {
            return PlantablesConfig.isSoilValidForSeed(soilId, plantId);
        }
        if (PlantablesConfig.isValidSapling(plantId)) {
            return PlantablesConfig.isSoilValidForSapling(soilId, plantId);
        }
        return false;
    }

    private boolean isTree() {
        ItemStack plantStack = this.inventory.getStackInSlot(0);
        if (plantStack.isEmpty()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(plantStack);
        return PlantablesConfig.isValidSapling(itemId);
    }

    private boolean isCrop() {
        ItemStack plantStack = this.inventory.getStackInSlot(0);
        if (plantStack.isEmpty()) {
            return false;
        }
        String itemId = RegistryHelper.getItemId(plantStack);
        return PlantablesConfig.isValidSeed(itemId);
    }

    private int getBaseGrowthTime(ItemStack plantStack) {
        String itemId = RegistryHelper.getItemId(plantStack);
        if (PlantablesConfig.isValidSeed(itemId)) {
            return Config.getPlanterBaseProcessingTime();
        }
        if (PlantablesConfig.isValidSapling(itemId)) {
            return PlantablesConfig.getBaseSaplingGrowthTime(itemId);
        }
        return Config.getPlanterBaseProcessingTime();
    }

    public float getSoilGrowthModifier(ItemStack soilStack) {
        if (soilStack.isEmpty()) {
            return 1.0f;
        }
        String soilId = RegistryHelper.getItemId(soilStack);
        return PlantablesConfig.getSoilGrowthModifier(soilId);
    }

    private static void tryOutputItemsBelow(Level level, BlockPos pos, AdvancedPlanterBlockEntity blockEntity) {
        BlockPos belowPos = pos.below();
        BlockEntity targetEntity = level.getBlockEntity(belowPos);
        if (targetEntity == null) {
            return;
        }
        IItemHandler targetInventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, belowPos, (Object)Direction.UP);
        if (targetInventory == null) {
            return;
        }
        boolean changed = false;
        for (int slot = 5; slot <= 16; ++slot) {
            ItemStack extractedItem;
            if (blockEntity.inventory.getStackInSlot(slot).isEmpty() || (extractedItem = blockEntity.inventory.extractItem(slot, 64, true)).isEmpty()) continue;
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedItem, (boolean)false);
            int insertedAmount = extractedItem.getCount() - remaining.getCount();
            if (insertedAmount <= 0) continue;
            blockEntity.inventory.extractItem(slot, insertedAmount, false);
            changed = true;
        }
        if (changed) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
        }
    }

    public boolean hasOutputSpace() {
        List<ItemStack> potentialDrops = this.getHarvestDrops(this.inventory.getStackInSlot(0));
        HashMap<Integer, ItemStack> simulatedSlots = new HashMap<Integer, ItemStack>();
        for (int slot = 5; slot <= 16; ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            simulatedSlots.put(slot, stack.isEmpty() ? ItemStack.EMPTY : stack.copy());
        }
        for (ItemStack drop : potentialDrops) {
            ItemStack existingStack;
            int slot;
            int remainingToPlace = drop.getCount();
            for (slot = 5; slot <= 16; ++slot) {
                existingStack = (ItemStack)simulatedSlots.get(slot);
                if (existingStack.isEmpty() || !existingStack.is(drop.getItem()) || existingStack.getCount() >= existingStack.getMaxStackSize()) continue;
                int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
                int itemsToAdd = Math.min(spaceAvailable, remainingToPlace);
                existingStack.grow(itemsToAdd);
                if ((remainingToPlace -= itemsToAdd) <= 0) break;
            }
            if (remainingToPlace > 0) {
                for (slot = 5; slot <= 16; ++slot) {
                    existingStack = (ItemStack)simulatedSlots.get(slot);
                    if (!existingStack.isEmpty()) continue;
                    simulatedSlots.put(slot, new ItemStack((ItemLike)drop.getItem(), remainingToPlace));
                    remainingToPlace = 0;
                    break;
                }
            }
            if (remainingToPlace <= 0) continue;
            return false;
        }
        return true;
    }

    private void resetGrowth() {
        this.growthProgress = 0;
        this.growthTicks = 0;
        this.readyToHarvest = false;
        this.lastGrowthStage = -1;
        this.setChanged();
    }

    public void harvestPlant() {
        if (!this.readyToHarvest) {
            return;
        }
        ItemStack plantStack = this.inventory.getStackInSlot(0);
        List<ItemStack> drops = this.getHarvestDrops(plantStack);
        float fertilizerYieldModifier = this.getFertilizerYieldModifier();
        float moduleYieldModifier = this.getModuleYieldModifier();
        float totalYieldModifier = fertilizerYieldModifier * moduleYieldModifier;
        drops = this.applyYieldModifier(drops, totalYieldModifier);
        for (ItemStack drop : drops) {
            int remainingItemsToPlace = drop.getCount();
            for (int slot = 5; slot <= 16; ++slot) {
                ItemStack existingStack = this.inventory.getStackInSlot(slot);
                if (existingStack.isEmpty()) {
                    int itemsToPlace = Math.min(remainingItemsToPlace, drop.getMaxStackSize());
                    this.inventory.setStackInSlot(slot, new ItemStack((ItemLike)drop.getItem(), itemsToPlace));
                    remainingItemsToPlace -= itemsToPlace;
                } else if (existingStack.is(drop.getItem()) && existingStack.getCount() < existingStack.getMaxStackSize()) {
                    int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
                    int itemsToAdd = Math.min(spaceAvailable, remainingItemsToPlace);
                    existingStack.grow(itemsToAdd);
                    remainingItemsToPlace -= itemsToAdd;
                }
                if (remainingItemsToPlace <= 0) break;
            }
            if (remainingItemsToPlace <= 0) continue;
            break;
        }
        this.consumeFertilizerForGrowthCycle();
        this.resetGrowth();
    }

    private void consumeFertilizerForGrowthCycle() {
        ItemStack fertilizerStack = this.inventory.getStackInSlot(4);
        if (!fertilizerStack.isEmpty()) {
            fertilizerStack.shrink(1);
            this.inventory.setStackInSlot(4, fertilizerStack.isEmpty() ? ItemStack.EMPTY : fertilizerStack);
            this.setChanged();
        }
    }

    private List<ItemStack> getHarvestDrops(ItemStack plantStack) {
        List<PlantablesConfig.DropInfo> configDrops;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = new Random();
        if (plantStack.isEmpty()) {
            return drops;
        }
        String plantId = RegistryHelper.getItemId(plantStack);
        if (PlantablesConfig.isValidSeed(plantId)) {
            configDrops = PlantablesConfig.getCropDrops(plantId);
        } else if (PlantablesConfig.isValidSapling(plantId)) {
            configDrops = PlantablesConfig.getTreeDrops(plantId);
        } else {
            return drops;
        }
        for (PlantablesConfig.DropInfo dropInfo : configDrops) {
            Item item;
            if (!(random.nextFloat() <= dropInfo.chance)) continue;
            int count = dropInfo.minCount;
            if (dropInfo.maxCount > dropInfo.minCount) {
                count = dropInfo.minCount + random.nextInt(dropInfo.maxCount - dropInfo.minCount + 1);
            }
            if ((item = RegistryHelper.getItem(dropInfo.item)) == null) continue;
            drops.add(new ItemStack((ItemLike)item, count));
        }
        return drops;
    }

    private List<ItemStack> applyYieldModifier(List<ItemStack> drops, float yieldModifier) {
        if (yieldModifier == 1.0f) {
            return drops;
        }
        ArrayList<ItemStack> modifiedDrops = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            int newCount = Math.max(1, Math.round((float)drop.getCount() * yieldModifier));
            modifiedDrops.add(new ItemStack((ItemLike)drop.getItem(), newCount));
        }
        return modifiedDrops;
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("growthProgress", this.growthProgress);
        tag.putInt("growthTicks", this.growthTicks);
        tag.putBoolean("readyToHarvest", this.readyToHarvest);
        tag.putInt("energyStored", this.energyStored);
        tag.putInt("lastGrowthStage", this.lastGrowthStage);
        tag.putFloat("currentTotalModifier", this.currentTotalModifier);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.growthProgress = tag.getInt("growthProgress");
        this.growthTicks = tag.getInt("growthTicks");
        this.readyToHarvest = tag.getBoolean("readyToHarvest");
        this.energyStored = tag.getInt("energyStored");
        this.lastGrowthStage = tag.getInt("lastGrowthStage");
        this.currentTotalModifier = tag.getFloat("currentTotalModifier");
    }

    public float getGrowthProgress() {
        return (float)this.growthProgress / 100.0f;
    }

    public int getGrowthStage() {
        if (this.isTree()) {
            return this.growthProgress > 50 ? 1 : 0;
        }
        return Math.min(8, (int)((float)this.growthProgress / 12.5f));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    private class OutputOnlyItemHandler
    implements IItemHandler {
        private final ItemStackHandler original;
        private final int firstOutputSlot;
        private final int lastOutputSlot;

        public OutputOnlyItemHandler(AdvancedPlanterBlockEntity advancedPlanterBlockEntity, ItemStackHandler original, int firstOutputSlot, int lastOutputSlot) {
            this.original = original;
            this.firstOutputSlot = firstOutputSlot;
            this.lastOutputSlot = lastOutputSlot;
        }

        public int getSlots() {
            return this.original.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.original.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= this.firstOutputSlot && slot <= this.lastOutputSlot) {
                return this.original.extractItem(slot, amount, simulate);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return this.original.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

