/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechevolved.block.custom;

import com.blocklogic.agritechevolved.block.ATEBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class InfusedFarmlandBlock
extends FarmBlock {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final IntegerProperty MOISTURE = BlockStateProperties.MOISTURE;

    public InfusedFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MOISTURE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? Blocks.DIRT.defaultBlockState() : super.getStateForPlacement(context);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.getBlockState(pos.above());
        if (blockstate.is(Blocks.BAMBOO) || blockstate.is(Blocks.CACTUS) || blockstate.is(Blocks.BAMBOO_SAPLING)) {
            return true;
        }
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock || blockstate.getBlock() instanceof MovingPistonBlock;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        if (facing != Direction.UP) {
            return TriState.FALSE;
        }
        if (plant.getBlock() instanceof BushBlock) {
            return TriState.TRUE;
        }
        if (plant.getBlock() instanceof CropBlock) {
            return TriState.TRUE;
        }
        if (plant.getBlock() instanceof StemBlock) {
            return TriState.TRUE;
        }
        return TriState.DEFAULT;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.getValue((Property)MOISTURE);
        if (!InfusedFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (moisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!InfusedFarmlandBlock.shouldMaintainFarmland((BlockGetter)level, pos)) {
                InfusedFarmlandBlock.turnToMulch(null, state, (Level)level, pos);
            }
        } else if (moisture < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        if (moisture == 7 && random.nextFloat() < 0.45f) {
            this.bonemealCrop(level, pos);
        }
    }

    private void bonemealCrop(ServerLevel level, BlockPos pos) {
        BlockPos cropPos = pos.above();
        BlockState crop = level.getBlockState(cropPos);
        BlockState newCrop = null;
        Block block = crop.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropblock = (CropBlock)block;
            if (!cropblock.isMaxAge(crop)) {
                newCrop = cropblock.getStateForAge(cropblock.getAge(crop) + 1);
            }
        } else if (crop.getBlock() instanceof StemBlock) {
            int age = (Integer)crop.getValue((Property)StemBlock.AGE);
            if (age < 7) {
                newCrop = (BlockState)crop.setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(age + 1));
            }
        } else if (crop.is(Blocks.SWEET_BERRY_BUSH)) {
            int age = (Integer)crop.getValue((Property)SweetBerryBushBlock.AGE);
            if (age < 3) {
                newCrop = (BlockState)crop.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(age + 1));
            }
        } else {
            BonemealableBlock bonemealable;
            block = crop.getBlock();
            if (block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, cropPos, crop)) {
                bonemealable.performBonemeal(level, level.random, cropPos, crop);
            }
        }
        if (newCrop != null) {
            level.setBlockAndUpdate(cropPos, newCrop);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 1.0f, entity.damageSources().fall());
    }

    public static void turnToMulch(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState dirtState = InfusedFarmlandBlock.pushEntitiesUp(state, ((Block)ATEBlocks.MULCH.get()).defaultBlockState(), level, pos);
        level.setBlockAndUpdate(pos, dirtState);
    }

    private static BlockState pushEntitiesUp(BlockState state, BlockState newState, Level level, BlockPos pos) {
        VoxelShape oldShape = state.getCollisionShape((BlockGetter)level, pos);
        VoxelShape newShape = newState.getCollisionShape((BlockGetter)level, pos);
        if (!oldShape.isEmpty() && newShape.isEmpty()) {
            return newState;
        }
        double yOffset = newShape.max(Direction.Axis.Y) - oldShape.max(Direction.Axis.Y);
        if (yOffset > 0.0) {
            level.getEntities(null, oldShape.bounds().move(pos)).forEach(entity -> entity.teleportTo(entity.getX(), entity.getY() + yOffset, entity.getZ()));
        }
        return newState;
    }

    private static boolean shouldMaintainFarmland(BlockGetter level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-6, 0, -6), (BlockPos)pos.offset(6, 1, 6))) {
            if (!level.getBlockState(nearbyPos).is(BlockTags.CROPS)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-6, 0, -6), (BlockPos)pos.offset(6, 1, 6))) {
            if (!level.getFluidState(nearbyPos).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!state.canSurvive((LevelReader)level, pos)) {
            InfusedFarmlandBlock.turnToMulch(null, state, level, pos);
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean isFertile(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }
}

