/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class DarkOakEnderman
extends BaseEnderman {
    public DarkOakEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.243).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnDarkOakEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        return BaseEnderman.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    public boolean canShake() {
        return false;
    }

    @Override
    @Nullable
    public MobEffectInstance getAreaEffect() {
        return new MobEffectInstance(MobEffects.DARKNESS, 100, 1);
    }

    @Override
    @Nullable
    public SoundEvent getAreaEffectSound() {
        return (SoundEvent)ModSoundEvents.DARK_OAK_DARKNESS.get();
    }

    @Override
    public int getAreaEffectRange() {
        return 20;
    }

    @Override
    public Vec3 getHeldBlockOffset() {
        return new Vec3(0.0, -0.6, 0.0);
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.DARK_OAK_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_DEATH.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_DEATH.get();
    }

    @Override
    public SoundEvent getStareSound() {
        return (SoundEvent)ModSoundEvents.DARK_OAK_ENDERMAN_STARE.get();
    }
}

