/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.ponder;

import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.content.irrigation_tower.IrrigationTowerBlockEntity;
import org.forsteri.ratatouille.entry.CRFluids;
import vectorwing.farmersdelight.common.block.RichSoilFarmlandBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class IrrigationTowerScene {
    public static void irrigationTower(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("irrigation_tower", "Use irrigation tower to improve your farmLand");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.idle(5);
        BlockPos towerPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().fromTo(towerPos, towerPos), Direction.DOWN);
        scene.overlay().showText(50).text("Irrigation towers maintain optimal moisture levels for farmland within their range").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(towerPos));
        scene.idle(60);
        scene.overlay().showText(50).text("The tank need to be filled with water").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(towerPos));
        scene.world().setBlock(towerPos.below().west(), Blocks.FARMLAND.defaultBlockState(), true);
        scene.world().setBlock(towerPos.below().south(), Blocks.FARMLAND.defaultBlockState(), true);
        scene.world().setBlock(towerPos.below().east(), Blocks.FARMLAND.defaultBlockState(), true);
        scene.world().setBlock(towerPos.below().north(), Blocks.FARMLAND.defaultBlockState(), true);
        scene.idle(10);
        scene.overlay().showControls(util.vector().blockSurface(towerPos, Direction.UP), Pointing.DOWN, 60).rightClick().withItem(new ItemStack((ItemLike)Items.WATER_BUCKET)).rightClick();
        scene.world().modifyBlockEntity(towerPos, IrrigationTowerBlockEntity.class, be -> be.getTankInventory().fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE));
        scene.idle(60);
        scene.world().setBlock(towerPos.below().north(), (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(10);
        scene.world().setBlock(towerPos.below().west(), (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(20);
        scene.world().setBlock(towerPos.below().south(), (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(5);
        scene.world().setBlock(towerPos.below().east(), (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(50);
        scene.overlay().showText(40).text("or filled with compost tea").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(towerPos));
        scene.world().modifyBlockEntity(towerPos, IrrigationTowerBlockEntity.class, be -> be.getTankInventory().drain(1000, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(towerPos, Direction.UP), Pointing.DOWN, 60).rightClick().withItem(new ItemStack((ItemLike)CRFluids.COMPOST_TEA.getBucket().get())).rightClick();
        scene.world().modifyBlockEntity(towerPos, IrrigationTowerBlockEntity.class, be -> be.getTankInventory().fill(new FluidStack((Fluid)CRFluids.COMPOST_TEA.get(), 1000), IFluidHandler.FluidAction.EXECUTE));
        scene.idle(30);
        scene.overlay().showText(50).text("This will slowly convert the surrounding farmland into rich soil farmland").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(towerPos));
        scene.idle(60);
        scene.world().setBlock(towerPos.below().north(), (BlockState)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).defaultBlockState().setValue((Property)RichSoilFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(10);
        scene.world().setBlock(towerPos.below().west(), (BlockState)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).defaultBlockState().setValue((Property)RichSoilFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(20);
        scene.world().setBlock(towerPos.below().south(), (BlockState)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).defaultBlockState().setValue((Property)RichSoilFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
        scene.idle(5);
        scene.world().setBlock(towerPos.below().east(), (BlockState)((Block)ModBlocks.RICH_SOIL_FARMLAND.get()).defaultBlockState().setValue((Property)RichSoilFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(7)), false);
    }
}

