/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.squeeze_basin;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRItems;
import org.jetbrains.annotations.NotNull;

public class SqueezeBasinBlock
extends HorizontalDirectionalBlock
implements IBE<SqueezeBasinBlockEntity>,
IWrenchable {
    public static final BooleanProperty CASING = BooleanProperty.create((String)"casing");
    public static final MapCodec<SqueezeBasinBlock> CODEC = SqueezeBasinBlock.simpleCodec(SqueezeBasinBlock::new);

    public SqueezeBasinBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CASING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @ParametersAreNonnullByDefault
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
            if (!stack.isEmpty()) {
                FluidStack drained;
                if (stack.is(((MechanicalPressBlock)AllBlocks.MECHANICAL_PRESS.get()).asItem())) {
                    BlockPos presserPos = pos.above(2);
                    if (!(level.getBlockState(presserPos).getBlock() instanceof AirBlock)) return ItemInteractionResult.FAIL;
                    level.setBlockAndUpdate(presserPos, ((MechanicalPressBlock)AllBlocks.MECHANICAL_PRESS.get()).getStateForPlacement(new BlockPlaceContext(new UseOnContext(player, hand, hitResult.withPosition(presserPos)))));
                    if (player.isCreative()) return ItemInteractionResult.SUCCESS;
                    stack.shrink(1);
                    return ItemInteractionResult.SUCCESS;
                }
                if (stack.is((Item)CRItems.SAUSAGE_CASING.get()) && !((Boolean)state.getValue((Property)CASING)).booleanValue()) {
                    stack.shrink(1);
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CASING, (Comparable)Boolean.valueOf(true)));
                    return ItemInteractionResult.SUCCESS;
                }
                if (FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)be)) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)be)) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack) || GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (!stack.getItem().equals(Items.SPONGE)) return ItemInteractionResult.SUCCESS;
                IFluidHandler fluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
                if (fluidHandler == null || (drained = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                return ItemInteractionResult.SUCCESS;
            }
            IItemHandlerModifiable inv = be.itemCapability;
            if (inv == null) {
                inv = new ItemStackHandler(1);
            }
            boolean success = false;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.isEmpty()) continue;
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
                success = true;
            }
            if (success) {
                level.playSound((Player)null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + level.random.nextFloat());
            }
            be.onEmptied();
            return ItemInteractionResult.SUCCESS;
        });
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos.above());
        return !(blockEntity instanceof MechanicalPressBlockEntity);
    }

    public Class<SqueezeBasinBlockEntity> getBlockEntityClass() {
        return SqueezeBasinBlockEntity.class;
    }

    public BlockEntityType<? extends SqueezeBasinBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.SQUEEZE_BASIN_ENTITY.get();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferredFacing = context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? preferredFacing : preferredFacing.getOpposite()))).setValue((Property)CASING, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{CASING, FACING}));
    }
}

