/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven_fan;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlockEntity;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRBlocks;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class OvenFanBlock
extends HorizontalKineticBlock
implements ICogWheel,
IWrenchable,
IBE<OvenFanBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public OvenFanBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, worldIn, pos, oldState, isMoving);
        this.blockUpdate(state, (LevelAccessor)worldIn, pos);
    }

    protected void blockUpdate(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (!(worldIn instanceof WrappedLevel)) {
            this.notifyOvenFanBlockEntity(worldIn, pos);
        }
    }

    protected void notifyOvenFanBlockEntity(LevelAccessor world, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)world, pos, OvenFanBlockEntity::blockInFrontChanged);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public void updateIndirectNeighbourShapes(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        super.updateIndirectNeighbourShapes(stateIn, worldIn, pos, flags, count);
        this.blockUpdate(stateIn, worldIn, pos);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.blockUpdate(state, (LevelAccessor)worldIn, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)heldItem.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        Direction direction = (Direction)pState.getValue(HORIZONTAL_FACING);
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.WEST -> Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)0.8125, (double)1.0, (double)1.0);
            case Direction.EAST -> Shapes.create((double)0.1875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            case Direction.NORTH -> Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.8125);
            case Direction.SOUTH -> Shapes.create((double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0);
            case Direction.UP, Direction.DOWN -> Shapes.block();
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferredFacing = this.getPreferredHorizontalFacing(context);
        if (preferredFacing == null) {
            preferredFacing = context.getHorizontalDirection();
        }
        return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? preferredFacing : preferredFacing.getOpposite()));
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        this.blockUpdate(newState, (LevelAccessor)context.getLevel(), context.getClickedPos());
        return newState;
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<OvenFanBlockEntity> getBlockEntityClass() {
        return OvenFanBlockEntity.class;
    }

    public BlockEntityType<? extends OvenFanBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntityTypes.OVEN_FAN_ENTITY.get();
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CRBlocks.OVEN_FAN.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> CRBlocks.OVEN_FAN.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)((Direction)state.getValue(HORIZONTAL_FACING)).getAxis(), dir -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.relative((Direction)directions.get(0)), s -> (BlockState)s.setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue(HORIZONTAL_FACING))));
        }
    }
}

