/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven;

import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.forsteri.ratatouille.content.oven.OvenBlockEntity;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlock;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlockEntity;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class BakeData {
    public int fanLevel;
    public int sizeLevel;
    public int tempLevel;
    public int updateRequired;

    public void tick(OvenBlockEntity oven) {
        if (this.updateOven(oven)) {
            oven.notifyUpdate();
        }
        this.processFood(oven);
    }

    public boolean updateOven(OvenBlockEntity controller) {
        assert (controller.getLevel() != null);
        BlockPos controllerPos = controller.getBlockPos();
        Level level = controller.getLevel();
        --this.updateRequired;
        int prevTemp = this.tempLevel;
        this.tempLevel = 0;
        for (int xOffset = 0; xOffset < controller.radius; ++xOffset) {
            for (int zOffset = 0; zOffset < controller.radius; ++zOffset) {
                float heat;
                BlockPos pos = controllerPos.offset(xOffset, -1, zOffset);
                BlockState blockState = level.getBlockState(pos);
                if (!(blockState.getBlock() instanceof BlazeBurnerBlock) && !blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) || !((heat = (float)BoilerHeaters.blazeBurner((Level)level, (BlockPos)pos, (BlockState)blockState)) > 0.0f)) continue;
                this.tempLevel = (int)((float)this.tempLevel + heat);
            }
        }
        int fanLevelBefore = this.fanLevel;
        float newFanLevel = 0.0f;
        for (int i = 0; i < controller.radius; ++i) {
            for (int j = 0; j < controller.height; ++j) {
                for (int k = 0; k < controller.radius; ++k) {
                    for (Direction direction : Direction.values()) {
                        OvenFanBlockEntity fan;
                        BlockPos pos = controller.getBlockPos().offset(i, j, k).relative(direction);
                        BlockState state = controller.getLevel().getBlockState(pos);
                        if (!(state.getBlock() instanceof OvenFanBlock) || state.getValue(OvenFanBlock.HORIZONTAL_FACING) != direction.getOpposite() || (fan = (OvenFanBlockEntity)controller.getLevel().getBlockEntity(pos)) == null) continue;
                        if (Mth.abs((float)fan.getSpeed()) == 256.0f) {
                            newFanLevel += 1.0f;
                            continue;
                        }
                        if (!(Mth.abs((float)fan.getSpeed()) >= 128.0f)) continue;
                        newFanLevel += 0.5f;
                    }
                }
            }
        }
        this.fanLevel = (int)newFanLevel;
        this.fanLevel = Math.clamp((long)this.fanLevel, 0, 8);
        this.tempLevel = Math.clamp((long)this.tempLevel, 0, 8);
        return this.tempLevel != prevTemp || fanLevelBefore != this.fanLevel;
    }

    public void processFood(OvenBlockEntity oven) {
        List<List<List<OvenBlockEntity.Inventory>>> inventories = oven.inventories;
        if (inventories == null) {
            return;
        }
        for (List<List<OvenBlockEntity.Inventory>> x : inventories) {
            for (List<OvenBlockEntity.Inventory> y : x) {
                for (OvenBlockEntity.Inventory inventory : y) {
                    if (inventory == null || inventory.tickTillFinishCooking < 0) continue;
                    if (inventory.tickTillFinishCooking > 0) {
                        inventory.tickTillFinishCooking -= Math.min(Math.min(this.fanLevel, this.sizeLevel), this.tempLevel);
                    }
                    if (inventory.tickTillFinishCooking > 0 || inventory.lastRecipe == null) continue;
                    ItemStack resultStack = inventory.lastRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).copy();
                    resultStack.setCount(inventory.getStackInSlot(0).getCount());
                    inventory.setStackInSlot(0, resultStack);
                }
            }
        }
        oven.notifyUpdate();
    }

    public boolean evaluate(OvenBlockEntity oven) {
        assert (oven.getLevel() != null);
        int sizeLevelBefore = this.sizeLevel;
        this.sizeLevel = oven.radius * oven.height * oven.radius / 4;
        this.sizeLevel = Math.clamp((long)this.sizeLevel, 0, 8);
        return sizeLevelBefore != this.sizeLevel;
    }

    public void clear() {
        this.fanLevel = 0;
        this.sizeLevel = 0;
        this.tempLevel = 0;
    }

    public void read(CompoundTag compound, boolean ignoredClientPacket) {
        this.fanLevel = compound.getInt("fanCount");
        this.sizeLevel = compound.getInt("sizeCount");
        this.tempLevel = compound.getInt("tempCount");
    }

    public void write(CompoundTag compound, boolean ignoredClientPacket) {
        compound.putInt("fanCount", this.fanLevel);
        compound.putInt("sizeCount", this.sizeLevel);
        compound.putInt("tempCount", this.tempLevel);
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.sizeLevel, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.tempLevel, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getFanComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("fan", this.fanLevel, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect("oven." + label, new Object[0]).withStyle(style1).append((Component)Lang.translateDirect("oven." + label + "_dots", new Object[0]).withStyle(style2)).append((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        int clamped = Mth.clamp((int)level, (int)0, (int)8);
        return Component.literal((String)("\u2588".repeat(clamped) + "\u2591".repeat(8 - clamped)));
    }

    private MutableComponent barComponent(int level) {
        return Component.empty().append((Component)this.bars(Math.max(0, -1), ChatFormatting.DARK_GREEN)).append((Component)this.bars(0, ChatFormatting.GREEN)).append((Component)this.bars(Math.max(0, level - 0), ChatFormatting.DARK_GREEN)).append((Component)this.bars(Math.max(0, 8 - level), ChatFormatting.DARK_RED)).append((Component)this.bars(Math.max(0, Math.min(10, 2)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.literal((String)Strings.repeat((char)'|', (int)level)).withStyle(format);
    }

    @NotNull
    public MutableComponent getLevelComponent() {
        int ovenLevel = Math.min(this.fanLevel, Math.min(this.sizeLevel, this.tempLevel));
        if (ovenLevel == 0) {
            return Lang.translateDirect("oven.idle", new Object[0]);
        }
        return ovenLevel >= 8 ? Lang.translateDirect("oven.max_lvl", new Object[0]) : Lang.translateDirect("oven.lvl", new Object[0]).append(String.valueOf(ovenLevel));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean ignoredIsPlayerSneaking, int ovenSize) {
        MutableComponent indent = Component.literal((String)"    ");
        MutableComponent indent2 = Component.literal((String)"     ");
        tooltip.add((Component)indent.copy().append((Component)Lang.translateDirect("oven.status", new Object[0]).append((Component)this.getLevelComponent().withStyle(ChatFormatting.GREEN))));
        tooltip.add((Component)indent2.copy().append((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.copy().append((Component)this.getFanComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.copy().append((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        return true;
    }
}

