/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.irrigation_tower;

import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRFluids;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class IrrigationTowerBlockEntity
extends FluidTankBlockEntity {
    public IrrigationTowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * 1000);
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (this.isController()) {
            this.tankInventory.setCapacity(this.getTotalTankSize() * 1000);
            this.tankInventory.readFromNBT(registries, compound.getCompound("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int getTankSize(int tank) {
        return 1000;
    }

    public static void isNearWater(LevelReader pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pPos.offset(-8, -1, -8), (BlockPos)pPos.offset(8, 1, 8))) {
            IrrigationTowerBlockEntity be;
            FluidStack fluid;
            BlockEntity blockEntity = pLevel.getBlockEntity(blockpos.above());
            if (!(blockEntity instanceof IrrigationTowerBlockEntity) || (fluid = (be = (IrrigationTowerBlockEntity)blockEntity).getTankInventory().getFluid()).isEmpty() || !fluid.getFluid().isSame((Fluid)Fluids.WATER) && !fluid.getFluid().isSame((Fluid)CRFluids.COMPOST_TEA.get())) continue;
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.IRRIGATION_TOWER_BLOCK_ENTITY.get(), (be, context) -> be.fluidCapability);
    }

    protected SmartFluidTank createInventory() {
        return new IrrigationSmartFluidTank(1000, x$0 -> this.onFluidStackChanged((FluidStack)x$0));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.level == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, null));
    }

    public static class IrrigationSmartFluidTank
    extends SmartFluidTank {
        public IrrigationSmartFluidTank(int capacity, Consumer<FluidStack> updateCallback) {
            super(capacity, updateCallback);
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().isSame((Fluid)Fluids.WATER) || stack.getFluid().isSame(((BaseFlowingFluid.Flowing)CRFluids.COMPOST_TEA.get()).getSource());
        }
    }
}

