/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlockEntity;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.jetbrains.annotations.NotNull;

public class CompostingRecipe
extends StandardProcessingRecipe<RecipeInput> {
    public CompostingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CRRecipeTypes.COMPOSTING, params);
    }

    public static void apply(CompostTowerBlockEntity controller, CompostingRecipe recipe) {
        ItemStackHandler inputInventory = controller.inputInventory;
        ItemStackHandler outputInventory = controller.outputInventory;
        CompostFluidTank tankInventory = controller.tankInventory;
        recipe.getIngredients().forEach(ingredient -> {
            for (int slot = 0; slot < inputInventory.getSlots(); ++slot) {
                ItemStack stackInSlot = inputInventory.getStackInSlot(slot);
                for (ItemStack item : ingredient.getItems()) {
                    if (!item.is(stackInSlot.getItem()) || stackInSlot.getCount() < item.getCount()) continue;
                    inputInventory.setStackInSlot(slot, stackInSlot.copyWithCount(stackInSlot.getCount() - item.getCount()));
                    return;
                }
            }
        });
        recipe.getFluidIngredients().forEach(fluidIngredient -> {
            for (int tank = 0; tank < tankInventory.getTanks(); ++tank) {
                FluidStack fluidInTank = tankInventory.getFluidInTank(tank);
                FluidStack fluidToDrain = fluidInTank.copy();
                fluidToDrain.setAmount(fluidIngredient.amount());
                if (!fluidIngredient.test(fluidInTank)) continue;
                tankInventory.drain(fluidToDrain, IFluidHandler.FluidAction.EXECUTE);
                return;
            }
        });
        recipe.rollResults(controller.getLevel().random).forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)outputInventory, (ItemStack)stack, (boolean)false));
        recipe.getFluidResults().forEach(fs -> tankInventory.fill((FluidStack)fs, IFluidHandler.FluidAction.EXECUTE));
    }

    public static boolean match(CompostTowerBlockEntity controller, Recipe<?> recipe) {
        boolean found;
        if (!(recipe instanceof CompostingRecipe)) {
            return false;
        }
        CompostingRecipe compostingRecipe = (CompostingRecipe)recipe;
        ItemStackHandler testInv = new ItemStackHandler(controller.inputInventory.getSlots());
        ItemHelper.copyContents((IItemHandler)controller.inputInventory, (IItemHandlerModifiable)testInv);
        for (Ingredient itemIngredient : compostingRecipe.getIngredients()) {
            found = false;
            block1: for (int slot = 0; slot < testInv.getSlots(); ++slot) {
                ItemStack stackInSlot = testInv.getStackInSlot(slot);
                for (ItemStack item : itemIngredient.getItems()) {
                    if (!item.is(stackInSlot.getItem()) || stackInSlot.getCount() < item.getCount()) continue;
                    found = true;
                    testInv.setStackInSlot(slot, stackInSlot.copyWithCount(stackInSlot.getCount() - item.getCount()));
                    continue block1;
                }
            }
            if (found) continue;
            return false;
        }
        for (SizedFluidIngredient fluidIngredient : compostingRecipe.getFluidIngredients()) {
            found = false;
            for (int tank = 0; tank < controller.tankInventory.getTanks(); ++tank) {
                FluidStack fluidInTank = controller.tankInventory.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank) || fluidInTank.getAmount() < fluidIngredient.amount()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected int getMaxInputCount() {
        return 192;
    }

    protected int getMaxOutputCount() {
        return 192;
    }

    protected int getMaxFluidInputCount() {
        return 3;
    }

    protected int getMaxFluidOutputCount() {
        return 3;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(RecipeInput recipeInput, @NotNull Level level) {
        for (Ingredient ingredient : this.ingredients) {
            for (int slot = 0; slot < recipeInput.size(); ++slot) {
                if (!ingredient.test(recipeInput.getItem(slot))) continue;
                return true;
            }
        }
        return false;
    }
}

